/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.alarm;

import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.alarm.IDampening;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;

public class DampeningActiveTime
implements IDampening {
    public static final long ACTIVE_FROM_RESET_VALUE = 0L;
    private Long activeTime;
    private Long activeFrom;
    private AlarmDefinition alarmDefinition;

    public DampeningActiveTime(AlarmDefinition alarmDefinition) {
        this.alarmDefinition = alarmDefinition;
        this.activeTime = Long.valueOf(alarmDefinition.getDampeningVar1());
        this.activeFrom = alarmDefinition.getDampeningInternal1() == null ? 0L : Long.valueOf(alarmDefinition.getDampeningInternal1());
    }

    @Override
    public boolean evaluate() {
        if (this.activeTime == 0L) {
            return false;
        }
        return this.activeFrom != 0L && System.currentTimeMillis() - this.activeFrom >= this.activeTime;
    }

    @Override
    public void reset() {
        this.activeFrom = 0L;
        this.update();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(AlarmUtils.DAMPENING_TYPE.CONSECUTIVE.getText());
        builder.append("=").append("activeFrom:").append(this.activeFrom);
        builder.append(", activeTime:").append(this.activeTime);
        return builder.toString();
    }

    @Override
    public AlarmDefinition getAlarmDefinition() {
        return this.alarmDefinition;
    }

    @Override
    public void update() {
        this.alarmDefinition.setDampeningInternal1(String.valueOf(this.activeFrom));
        DaoUtils.getAlarmDefinitionDao().update(this.alarmDefinition);
    }

    public Long getActiveTime() {
        return this.activeTime;
    }

    public Long getActiveFrom() {
        return this.activeFrom;
    }

    public void updateActiveFrom(Long activeFrom) {
        this.activeFrom = activeFrom;
        this.update();
    }
}

