/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.alarm;

import java.util.Date;
import java.util.List;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.alarm.DampeningActiveTime;
import org.mycontroller.standalone.alarm.DampeningConsecutive;
import org.mycontroller.standalone.alarm.DampeningLastNEvaluations;
import org.mycontroller.standalone.alarm.INotification;
import org.mycontroller.standalone.alarm.NotificationEmail;
import org.mycontroller.standalone.alarm.NotificationSMS;
import org.mycontroller.standalone.alarm.NotificationSendPayLoad;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.ResourcesLogsUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmEngine
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(AlarmEngine.class);
    private List<AlarmDefinition> alarmDefinitions;
    private Object resourceObject;

    public AlarmEngine(List<AlarmDefinition> alarmDefinitions, Object resourceObject) {
        this.alarmDefinitions = alarmDefinitions;
        this.resourceObject = resourceObject;
    }

    public AlarmEngine(List<AlarmDefinition> alarmDefinitions) {
        this(alarmDefinitions, null);
    }

    public void runAlarm(AlarmDefinition alarmDefinition) throws Exception {
        boolean triggerAlarm = false;
        String thresholdValue = null;
        Object actualValueObject = this.resourceObject;
        String actualValue = null;
        if (actualValueObject == null) {
            actualValueObject = new ResourceModel(alarmDefinition.getResourceType(), alarmDefinition.getResourceId()).getResource();
        }
        switch (alarmDefinition.getResourceType()) {
            case SENSOR_VARIABLE: {
                actualValue = ((SensorVariable)actualValueObject).getValue();
                break;
            }
            case NODE: {
                actualValue = ((Node)actualValueObject).getState().getText();
                break;
            }
            case GATEWAY: {
                actualValue = ((Gateway)actualValueObject).getState().getText();
                break;
            }
        }
        switch (alarmDefinition.getThresholdType()) {
            case VALUE: {
                thresholdValue = alarmDefinition.getThresholdValue();
                break;
            }
            case SENSOR_VARIABLE: {
                SensorVariable thresholdSensorValue = DaoUtils.getSensorVariableDao().get(NumericUtils.getInteger(alarmDefinition.getThresholdValue()));
                if (thresholdSensorValue == null) break;
                thresholdValue = thresholdSensorValue.getValue();
                break;
            }
            case GATEWAY_STATE: {
                Gateway gateway = (Gateway)DaoUtils.getGatewayDao().getById(NumericUtils.getInteger(alarmDefinition.getThresholdValue()));
                if (gateway == null) break;
                thresholdValue = gateway.getState().getText();
                break;
            }
            case NODE_STATE: {
                Node node = DaoUtils.getNodeDao().get(NumericUtils.getInteger(alarmDefinition.getThresholdValue()));
                if (node == null) break;
                thresholdValue = node.getState().getText();
                break;
            }
        }
        if (thresholdValue == null) {
            _logger.warn("Could not execute this item, it does not have threshold value! AlarmDefinition:[{}]", (Object)alarmDefinition);
            return;
        }
        switch (alarmDefinition.getTriggerType()) {
            case EQUAL: {
                if (!actualValue.equals(thresholdValue)) break;
                triggerAlarm = true;
                break;
            }
            case GREATER_THAN: {
                if (!(Double.parseDouble(actualValue) > Double.parseDouble(thresholdValue))) break;
                triggerAlarm = true;
                break;
            }
            case GREATER_THAN_EQUAL: {
                if (!(Double.parseDouble(actualValue) >= Double.parseDouble(thresholdValue))) break;
                triggerAlarm = true;
                break;
            }
            case LESSER_THAN: {
                if (!(Double.parseDouble(actualValue) < Double.parseDouble(thresholdValue))) break;
                triggerAlarm = true;
                break;
            }
            case LESSER_THAN_EQUAL: {
                if (!(Double.parseDouble(actualValue) <= Double.parseDouble(thresholdValue))) break;
                triggerAlarm = true;
                break;
            }
            case NOT_EQUAL: {
                if (actualValue.equals(thresholdValue)) break;
                triggerAlarm = true;
                break;
            }
        }
        switch (alarmDefinition.getDampeningType()) {
            case NONE: {
                this.alarmTriggerCall(alarmDefinition, actualValue, triggerAlarm);
                break;
            }
            case CONSECUTIVE: {
                DampeningConsecutive dampeningConsecutive = new DampeningConsecutive(alarmDefinition);
                if (triggerAlarm) {
                    dampeningConsecutive.incrementConsecutiveCount();
                } else {
                    dampeningConsecutive.setConsecutiveCount(0);
                    this.alarmTriggerCall(alarmDefinition, actualValue, triggerAlarm);
                }
                if (!dampeningConsecutive.evaluate()) break;
                dampeningConsecutive.reset();
                this.alarmTriggerCall(alarmDefinition, actualValue, triggerAlarm);
                break;
            }
            case LAST_N_EVALUATIONS: {
                DampeningLastNEvaluations lastNEvaluations = new DampeningLastNEvaluations(alarmDefinition);
                lastNEvaluations.incrementEvaluationsCount();
                if (triggerAlarm) {
                    lastNEvaluations.incrementOccurrencesCount();
                }
                if (!lastNEvaluations.isExecutable()) break;
                if (lastNEvaluations.evaluate()) {
                    this.alarmTriggerCall(alarmDefinition, actualValue, triggerAlarm);
                } else {
                    this.alarmTriggerCall(alarmDefinition, actualValue, false);
                }
                lastNEvaluations.reset();
                break;
            }
            case ACTIVE_TIME: {
                DampeningActiveTime dampeningActiveTime = new DampeningActiveTime(alarmDefinition);
                if (triggerAlarm) {
                    if (dampeningActiveTime.getActiveFrom() == 0L) {
                        dampeningActiveTime.updateActiveFrom(System.currentTimeMillis());
                        break;
                    }
                    if (!dampeningActiveTime.evaluate()) break;
                    this.alarmTriggerCall(alarmDefinition, actualValue, triggerAlarm);
                    break;
                }
                dampeningActiveTime.reset();
                this.alarmTriggerCall(alarmDefinition, actualValue, triggerAlarm);
                break;
            }
        }
        DaoUtils.getAlarmDefinitionDao().update(alarmDefinition);
    }

    private void alarmTriggerCall(AlarmDefinition alarmDefinition, String actualValue, boolean triggerAlarm) throws Exception {
        if (triggerAlarm) {
            if (!alarmDefinition.getTriggered().booleanValue() || !alarmDefinition.getIgnoreDuplicate().booleanValue()) {
                INotification notification = null;
                switch (alarmDefinition.getNotificationType()) {
                    case SEND_PAYLOAD: {
                        notification = new NotificationSendPayLoad(alarmDefinition);
                        break;
                    }
                    case SEND_EMAIL: {
                        notification = new NotificationEmail(alarmDefinition);
                        break;
                    }
                    case SEND_SMS: {
                        notification = new NotificationSMS(alarmDefinition);
                        break;
                    }
                    default: {
                        _logger.info("Not implemented this type:{}", (Object)alarmDefinition.getNotificationType().getText());
                    }
                }
                if (notification != null) {
                    notification.execute(actualValue);
                } else {
                    _logger.warn("Notification didn't executed for AlarmDefination:[{}]", (Object)alarmDefinition);
                }
                alarmDefinition.setTriggered(true);
                ResourcesLogsUtils.setAlarmLog(ResourcesLogsUtils.LOG_LEVEL.INFO, alarmDefinition, triggerAlarm, null);
                alarmDefinition.setLastTrigger(new Date().getTime());
                DaoUtils.getAlarmDefinitionDao().update(alarmDefinition);
            }
        } else if (alarmDefinition.getTriggered().booleanValue()) {
            alarmDefinition.setTriggered(false);
            DaoUtils.getAlarmDefinitionDao().update(alarmDefinition);
        }
    }

    @Override
    public void run() {
        for (AlarmDefinition alarmDefinition : this.alarmDefinitions) {
            try {
                if (alarmDefinition.getEnabled().booleanValue()) {
                    this.runAlarm(alarmDefinition);
                    continue;
                }
                _logger.debug("AlarmDefinition[{}] disabled, no action needed.");
            }
            catch (Exception ex) {
                _logger.error("failed to execute alarm:[{}],", (Object)alarmDefinition, (Object)ex);
                ResourcesLogsUtils.setAlarmLog(ResourcesLogsUtils.LOG_LEVEL.ERROR, alarmDefinition, null, ex.getMessage());
            }
        }
    }

    public static AlarmEngineBuilder builder() {
        return new AlarmEngineBuilder();
    }

    public static class AlarmEngineBuilder {
        private List<AlarmDefinition> alarmDefinitions;
        private Object resourceObject;

        AlarmEngineBuilder() {
        }

        public AlarmEngineBuilder alarmDefinitions(List<AlarmDefinition> alarmDefinitions) {
            this.alarmDefinitions = alarmDefinitions;
            return this;
        }

        public AlarmEngineBuilder resourceObject(Object resourceObject) {
            this.resourceObject = resourceObject;
            return this;
        }

        public AlarmEngine build() {
            return new AlarmEngine(this.alarmDefinitions, this.resourceObject);
        }

        public String toString() {
            return "AlarmEngine.AlarmEngineBuilder(alarmDefinitions=" + this.alarmDefinitions + ", resourceObject=" + this.resourceObject + ")";
        }
    }
}

