/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.uidtag;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.db.tables.UidTag;
import org.mycontroller.standalone.mysensors.MySensorsRawMessage;
import org.mycontroller.standalone.mysensors.structs.UidTagStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteUidTag
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(ExecuteUidTag.class);
    private Sensor sensor;
    private SensorVariable sensorVariable;

    public ExecuteUidTag(Sensor sensor, SensorVariable sensorVariable) {
        this.sensor = sensor;
    }

    private void executeUidTag() throws DecoderException {
        _logger.debug("UID TAG RX String:[{}]", (Object)this.sensorVariable.getValue());
        if (this.sensorVariable.getValue().equalsIgnoreCase("NA")) {
            return;
        }
        UidTagStruct uidTagStruct = new UidTagStruct();
        uidTagStruct.setByteBuffer(ByteBuffer.wrap(Hex.decodeHex((char[])this.sensorVariable.getValue().toCharArray())).order(ByteOrder.LITTLE_ENDIAN), 0);
        _logger.debug("ByteBuffer:[{}]", (Object)Hex.encodeHexString((byte[])uidTagStruct.getByteBuffer().array()));
        _logger.debug("UID TAG:[{}]", (Object)uidTagStruct.toString());
        MySensorsRawMessage mySensorsRawMessage = new MySensorsRawMessage(this.sensor.getNode().getGateway().getId(), this.sensor.getNode().getEuiInt(), this.sensor.getSensorId(), MYCMessages.MESSAGE_TYPE.C_SET.ordinal(), 0, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR5.ordinal(), Hex.encodeHexString((byte[])uidTagStruct.getByteBuffer().array()), true);
        UidTag uidTag = DaoUtils.getUidTagDao().get(uidTagStruct.getUid());
        if (uidTagStruct.getStatus() == 0) {
            SensorVariable sensorValueDes;
            if (uidTag != null && (sensorValueDes = DaoUtils.getSensorVariableDao().get(uidTag.getSensor().getId(), MYCMessages.MESSAGE_TYPE_SET_REQ.get(uidTagStruct.getType()))) != null) {
                uidTagStruct.setStatus(1);
                uidTagStruct.setPayload(Integer.valueOf(sensorValueDes.getValue()));
                mySensorsRawMessage.setPayload(Hex.encodeHexString((byte[])uidTagStruct.getByteBuffer().array()));
            }
        } else if (uidTag != null) {
            MySensorsRawMessage rawMessageToDevice = new MySensorsRawMessage(uidTag.getSensor().getNode().getGateway().getId(), uidTag.getSensor().getNode().getEuiInt(), uidTag.getSensor().getSensorId(), MYCMessages.MESSAGE_TYPE.C_SET.ordinal(), 0, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR5.ordinal(), String.valueOf(uidTagStruct.getPayload()), true);
            ObjectFactory.getRawMessageQueue().putMessage(rawMessageToDevice.getRawMessage());
        } else {
            uidTagStruct.setStatus(0);
            mySensorsRawMessage.setPayload(Hex.encodeHexString((byte[])uidTagStruct.getByteBuffer().array()));
        }
        ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
        _logger.debug("Message Sent:[{}]", (Object)mySensorsRawMessage.toString());
    }

    @Override
    public void run() {
        try {
            this.executeUidTag();
        }
        catch (Exception ex) {
            _logger.error("Exception,", (Throwable)ex);
        }
    }
}

