/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.mysensors.structs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javolution.io.Struct;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareConfigResponse
extends Struct {
    private static final Logger _logger = LoggerFactory.getLogger((String)FirmwareConfigResponse.class.getName());
    private final Struct.Unsigned16 type = new Struct.Unsigned16((Struct)this);
    private final Struct.Unsigned16 version = new Struct.Unsigned16((Struct)this);
    private final Struct.Unsigned16 blocks = new Struct.Unsigned16((Struct)this);
    private final Struct.Unsigned16 crc = new Struct.Unsigned16((Struct)this);

    public FirmwareConfigResponse() {
        try {
            this.setByteBuffer(ByteBuffer.wrap(Hex.decodeHex((char[])"FFFFFFFFFFFFFFFF".toCharArray())).order(ByteOrder.LITTLE_ENDIAN), 0);
        }
        catch (DecoderException ex) {
            _logger.error("Unable to create 'FirmwareConfigResponse' struct", (Throwable)ex);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Type/BlCommand:").append(this.getType());
        builder.append(", Version/BlData:").append(this.getVersion());
        builder.append(", Blocks:").append(this.getBlocks());
        builder.append(", CRC:").append(this.getCrc());
        return builder.toString();
    }

    private void loadBootloaderCommand(Integer command) {
        this.setBlocks(0);
        this.setCrc(55930);
        this.setType(command);
    }

    public void loadEraseEepromCommand() {
        this.loadBootloaderCommand(1);
    }

    public void loadNewNodeId(Integer nodeId) {
        this.loadBootloaderCommand(2);
        this.setVersion(nodeId);
    }

    public ByteOrder byteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public Integer getType() {
        return this.type.get();
    }

    public Integer getVersion() {
        return this.version.get();
    }

    public Integer getBlocks() {
        return this.blocks.get();
    }

    public Integer getCrc() {
        return this.crc.get();
    }

    public void setType(Integer type) {
        this.type.set(type.intValue());
    }

    public void setVersion(Integer version) {
        this.version.set(version.intValue());
    }

    public void setBlocks(Integer blocks) {
        this.blocks.set(blocks.intValue());
    }

    public void setCrc(Integer crc) {
        this.crc.set(crc.intValue());
    }
}

