/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.mysensors;

import org.apache.commons.codec.binary.Hex;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.api.jaxrs.mapper.PayloadJson;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.PayloadOperation;
import org.mycontroller.standalone.db.PayloadOperationUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.db.tables.ForwardPayload;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.db.tables.Timer;
import org.mycontroller.standalone.gateway.GatewayEthernet;
import org.mycontroller.standalone.gateway.GatewayException;
import org.mycontroller.standalone.interfaces.IActionEngine;
import org.mycontroller.standalone.model.ResourceModel;
import org.mycontroller.standalone.mysensors.MySensorsNodeDiscover;
import org.mycontroller.standalone.mysensors.MySensorsRawMessage;
import org.mycontroller.standalone.mysensors.MySensorsUtils;
import org.mycontroller.standalone.mysensors.structs.FirmwareConfigResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySensorsIActionEngine
implements IActionEngine {
    private static final Logger _logger = LoggerFactory.getLogger(MySensorsIActionEngine.class);

    @Override
    public void executeAlarm(AlarmDefinition alarmDefinition) {
    }

    @Override
    public void executeTimer(ResourceModel resourceModel, Timer timer) {
        PayloadOperation operation = new PayloadOperation(timer.getPayload());
        this.executeSendPayload(resourceModel, operation);
    }

    @Override
    public void executeSendPayload(ResourceModel resourceModel, PayloadOperation operation) {
        switch (resourceModel.getResourceType()) {
            case GATEWAY: {
                _logger.warn("I do not know how to handle gateway commands! do not assign me on gateway tasks!");
                return;
            }
            case NODE: {
                this.executeNodeOperationSendPayload((Node)resourceModel.getResource(), operation);
                break;
            }
            case SENSOR: {
                break;
            }
            case SENSOR_VARIABLE: {
                this.executeSensorVariableOperationSendPayload((SensorVariable)resourceModel.getResource(), operation);
                break;
            }
        }
    }

    private void executeNodeOperationSendPayload(Node node, PayloadOperation operation) {
        MySensorsRawMessage mySensorsRawMessage = null;
        if (operation.getOperationType() != null) {
            switch (operation.getOperationType()) {
                case REBOOT: {
                    mySensorsRawMessage = new MySensorsRawMessage(node.getGateway().getId(), node.getEuiInt(), 255, MYCMessages.MESSAGE_TYPE.C_INTERNAL.ordinal(), 0, MYCMessages.MESSAGE_TYPE_INTERNAL.I_REBOOT.ordinal(), "", true);
                    break;
                }
                default: {
                    _logger.warn("Not supported opration node:[{}]", (Object)operation.getOperationType().getText());
                    return;
                }
            }
        }
        if (mySensorsRawMessage != null) {
            ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeSensorVariableOperationSendPayload(SensorVariable sensorVariable, PayloadOperation operation) {
        MySensorsRawMessage mySensorsRawMessage;
        String payload;
        block6: {
            payload = null;
            mySensorsRawMessage = null;
            if (operation.getOperationType() != null) {
                switch (operation.getOperationType()) {
                    case ADD: 
                    case DECREMENT: 
                    case DIVIDE: 
                    case INCREMENT: 
                    case TOGGLE: 
                    case MODULUS: 
                    case MULTIPLIE: 
                    case SUBTRACT: {
                        if (sensorVariable != null && sensorVariable.getValue() != null) {
                            payload = PayloadOperationUtils.getPayload(operation, sensorVariable.getValue());
                            break block6;
                        } else {
                            _logger.warn("Unable to run special oprtaion, there is no value available for this sensor variable, Operation:[{}], SensorVariable", (Object)operation, (Object)sensorVariable);
                            return;
                        }
                    }
                    default: {
                        _logger.warn("Not supported opration! Operation for sensor variable:[{}]", (Object)operation.getOperationType().getText());
                        return;
                    }
                }
            }
            payload = operation.getPayload();
        }
        mySensorsRawMessage = new MySensorsRawMessage(sensorVariable.getSensor().getNode().getGateway().getId(), sensorVariable.getSensor().getNode().getEuiInt(), sensorVariable.getSensor().getSensorId(), MYCMessages.MESSAGE_TYPE.C_SET.ordinal(), 0, sensorVariable.getVariableType().ordinal(), payload, true);
        ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
    }

    @Override
    public void sendAliveStatusRequest(Node node) {
        MySensorsRawMessage mySensorsRawMessage = new MySensorsRawMessage(node.getGateway().getId(), node.getEuiInt(), 255, MYCMessages.MESSAGE_TYPE.C_INTERNAL.ordinal(), 0, MYCMessages.MESSAGE_TYPE_INTERNAL.I_HEARTBEAT.ordinal(), String.valueOf(System.currentTimeMillis()), true);
        ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
        _logger.debug("Hearbeat message sent for node:[{}], rawMessage:[{}]", (Object)node, (Object)mySensorsRawMessage);
    }

    @Override
    public boolean checkEthernetGatewayAliveState(GatewayEthernet gatewayEthernet) {
        MySensorsRawMessage mySensorsRawMessage = new MySensorsRawMessage(gatewayEthernet.getId(), 0, 255, MYCMessages.MESSAGE_TYPE.C_INTERNAL.ordinal(), 0, MYCMessages.MESSAGE_TYPE_INTERNAL.I_VERSION.ordinal(), "");
        try {
            if (ObjectFactory.getGateway(gatewayEthernet.getId()) != null) {
                ObjectFactory.getGateway(gatewayEthernet.getId()).write(mySensorsRawMessage.getRawMessage());
                return true;
            }
            _logger.warn("Gateway not available! Gateway[{}]", (Object)gatewayEthernet);
            return false;
        }
        catch (GatewayException ex) {
            _logger.error("Exception while checking gateway connection status: {}", (Object)ex.getMessage());
            return false;
        }
    }

    @Override
    public void executeForwardPayload(ForwardPayload forwardPayload, String payload) {
        MySensorsRawMessage mySensorsRawMessage = new MySensorsRawMessage(forwardPayload.getDestination().getSensor().getNode().getGateway().getId(), forwardPayload.getDestination().getSensor().getNode().getEuiInt(), forwardPayload.getDestination().getSensor().getSensorId(), MYCMessages.MESSAGE_TYPE.C_SET.ordinal(), 0, forwardPayload.getDestination().getVariableType().ordinal(), payload, true);
        ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
    }

    @Override
    public void rebootNode(Node node) {
        MySensorsRawMessage mySensorsRawMessage = new MySensorsRawMessage(node.getGateway().getId(), node.getEuiInt(), 255, MYCMessages.MESSAGE_TYPE.C_INTERNAL.ordinal(), 0, MYCMessages.MESSAGE_TYPE_INTERNAL.I_REBOOT.ordinal(), "", true);
        ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
    }

    @Override
    public void uploadFirmware(Node node) {
        FirmwareConfigResponse firmwareConfigResponse = new FirmwareConfigResponse();
        firmwareConfigResponse.setByteBufferPosition(0);
        firmwareConfigResponse.setType(node.getFirmware().getType().getId());
        firmwareConfigResponse.setVersion(node.getFirmware().getVersion().getId());
        firmwareConfigResponse.setBlocks(node.getFirmware().getBlocks());
        firmwareConfigResponse.setCrc(node.getFirmware().getCrc());
        MySensorsRawMessage mySensorsRawMessage = new MySensorsRawMessage(node.getGateway().getId(), node.getEuiInt(), 255, MYCMessages.MESSAGE_TYPE.C_STREAM.ordinal(), 0, MYCMessages.MESSAGE_TYPE_STREAM.ST_FIRMWARE_CONFIG_RESPONSE.ordinal(), Hex.encodeHexString((byte[])firmwareConfigResponse.getByteBuffer().array()).toUpperCase(), true);
        ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
    }

    @Override
    public void discover(Integer gatewayId) {
        if (MySensorsUtils.isDiscoverRunning(gatewayId)) {
            throw new RuntimeException("Discover already running! nothing to do..");
        }
        new Thread(new MySensorsNodeDiscover(gatewayId)).start();
    }

    @Override
    public void sendPayload(Sensor sensor, PayloadJson payload) {
        MySensorsRawMessage mySensorsRawMessage = new MySensorsRawMessage(sensor.getNode().getGateway().getId(), sensor.getNode().getEuiInt(), sensor.getSensorId(), MYCMessages.MESSAGE_TYPE.C_SET.ordinal(), 0, payload.getVariableType().ordinal(), payload.getPayload(), true);
        ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
    }

    @Override
    public void addNode(Node node) {
        MySensorsUtils.addUpdateNode(node, true);
    }

    @Override
    public void updateNode(Node node) {
        MySensorsUtils.addUpdateNode(node, false);
    }

    @Override
    public void eraseConfiguration(Node node) {
        node.setEraseConfig(true);
        DaoUtils.getNodeDao().update(node);
        this.rebootNode(node);
    }

    @Override
    public void addSensor(Sensor sensor) {
        MySensorsUtils.addUpdateSensor(sensor, true);
    }

    @Override
    public void updateSensor(Sensor sensor) {
        MySensorsUtils.addUpdateSensor(sensor, false);
    }

    @Override
    public void sendPayload(SensorVariable sensorVariable) {
        MySensorsRawMessage mySensorsRawMessage = new MySensorsRawMessage(sensorVariable.getSensor().getNode().getGateway().getId(), sensorVariable.getSensor().getNode().getEuiInt(), sensorVariable.getSensor().getSensorId(), MYCMessages.MESSAGE_TYPE.C_SET.ordinal(), 0, sensorVariable.getVariableType().ordinal(), sensorVariable.getValue(), true);
        ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
    }
}

