/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.tables;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.db.tables.Firmware;
import org.mycontroller.standalone.db.tables.Gateway;

@DatabaseTable(tableName="node")
public class Node {
    public static final String KEY_FIRMWARE_ID = "firmwareId";
    public static final String KEY_GATEWAY_ID = "gatewayId";
    public static final String KEY_GATEWAY_NAME = "gatewayName";
    public static final String KEY_STATE = "state";
    public static final String KEY_EUI = "eui";
    public static final String KEY_ID = "id";
    public static final String KEY_NAME = "name";
    public static final String KEY_TYPE = "type";
    public static final String KEY_VERSION = "version";
    public static final String KEY_LIB_VERSION = "libVersion";
    public static final String KEY_BATTERY_LEVEL = "batteryLevel";
    public static final String KEY_ERASE_CONFIG = "eraseConfig";
    public static final String KEY_LAST_SEEN = "laseSeen";
    @DatabaseField(generatedId=true, columnName="id")
    private Integer id;
    @DatabaseField(uniqueCombo=true, canBeNull=false, columnName="eui")
    private String eui;
    @DatabaseField(uniqueCombo=true, canBeNull=true, columnName="gatewayId", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=1)
    private Gateway gateway;
    @DatabaseField(columnName="name")
    private String name;
    @DatabaseField(columnName="version")
    private String version;
    @DatabaseField(dataType=DataType.ENUM_STRING, columnName="type")
    private MYCMessages.MESSAGE_TYPE_PRESENTATION type;
    @DatabaseField(columnName="libVersion")
    private String libVersion;
    @DatabaseField(columnName="batteryLevel")
    private String batteryLevel;
    @DatabaseField(canBeNull=true, columnName="eraseConfig")
    private Boolean eraseConfig;
    @DatabaseField(canBeNull=true, columnName="firmwareId", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=2)
    private Firmware firmware;
    @DatabaseField(canBeNull=false, dataType=DataType.ENUM_STRING, columnName="state")
    private AppProperties.STATE state = AppProperties.STATE.UNAVAILABLE;
    @DatabaseField(canBeNull=true, columnName="laseSeen")
    private Long lastSeen;

    public Integer getEuiInt() {
        return NumericUtils.getInteger(this.eui);
    }

    public static NodeBuilder builder() {
        return new NodeBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getEui() {
        return this.eui;
    }

    public Gateway getGateway() {
        return this.gateway;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public MYCMessages.MESSAGE_TYPE_PRESENTATION getType() {
        return this.type;
    }

    public String getLibVersion() {
        return this.libVersion;
    }

    public String getBatteryLevel() {
        return this.batteryLevel;
    }

    public Boolean getEraseConfig() {
        return this.eraseConfig;
    }

    public Firmware getFirmware() {
        return this.firmware;
    }

    public AppProperties.STATE getState() {
        return this.state;
    }

    public Long getLastSeen() {
        return this.lastSeen;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setEui(String eui) {
        this.eui = eui;
    }

    public void setGateway(Gateway gateway) {
        this.gateway = gateway;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setType(MYCMessages.MESSAGE_TYPE_PRESENTATION type) {
        this.type = type;
    }

    public void setLibVersion(String libVersion) {
        this.libVersion = libVersion;
    }

    public void setBatteryLevel(String batteryLevel) {
        this.batteryLevel = batteryLevel;
    }

    public void setEraseConfig(Boolean eraseConfig) {
        this.eraseConfig = eraseConfig;
    }

    public void setFirmware(Firmware firmware) {
        this.firmware = firmware;
    }

    public void setState(AppProperties.STATE state) {
        this.state = state;
    }

    public void setLastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$eui = this.getEui();
        String other$eui = other.getEui();
        if (this$eui == null ? other$eui != null : !this$eui.equals(other$eui)) {
            return false;
        }
        Gateway this$gateway = this.getGateway();
        Gateway other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !((Object)this$gateway).equals(other$gateway)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        MYCMessages.MESSAGE_TYPE_PRESENTATION this$type = this.getType();
        MYCMessages.MESSAGE_TYPE_PRESENTATION other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$libVersion = this.getLibVersion();
        String other$libVersion = other.getLibVersion();
        if (this$libVersion == null ? other$libVersion != null : !this$libVersion.equals(other$libVersion)) {
            return false;
        }
        String this$batteryLevel = this.getBatteryLevel();
        String other$batteryLevel = other.getBatteryLevel();
        if (this$batteryLevel == null ? other$batteryLevel != null : !this$batteryLevel.equals(other$batteryLevel)) {
            return false;
        }
        Boolean this$eraseConfig = this.getEraseConfig();
        Boolean other$eraseConfig = other.getEraseConfig();
        if (this$eraseConfig == null ? other$eraseConfig != null : !((Object)this$eraseConfig).equals(other$eraseConfig)) {
            return false;
        }
        Firmware this$firmware = this.getFirmware();
        Firmware other$firmware = other.getFirmware();
        if (this$firmware == null ? other$firmware != null : !((Object)this$firmware).equals(other$firmware)) {
            return false;
        }
        AppProperties.STATE this$state = this.getState();
        AppProperties.STATE other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Long this$lastSeen = this.getLastSeen();
        Long other$lastSeen = other.getLastSeen();
        return !(this$lastSeen == null ? other$lastSeen != null : !((Object)this$lastSeen).equals(other$lastSeen));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Node;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $eui = this.getEui();
        result = result * 59 + ($eui == null ? 43 : $eui.hashCode());
        Gateway $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : ((Object)$gateway).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        MYCMessages.MESSAGE_TYPE_PRESENTATION $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $libVersion = this.getLibVersion();
        result = result * 59 + ($libVersion == null ? 43 : $libVersion.hashCode());
        String $batteryLevel = this.getBatteryLevel();
        result = result * 59 + ($batteryLevel == null ? 43 : $batteryLevel.hashCode());
        Boolean $eraseConfig = this.getEraseConfig();
        result = result * 59 + ($eraseConfig == null ? 43 : ((Object)$eraseConfig).hashCode());
        Firmware $firmware = this.getFirmware();
        result = result * 59 + ($firmware == null ? 43 : ((Object)$firmware).hashCode());
        AppProperties.STATE $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Long $lastSeen = this.getLastSeen();
        result = result * 59 + ($lastSeen == null ? 43 : ((Object)$lastSeen).hashCode());
        return result;
    }

    public Node() {
    }

    @ConstructorProperties(value={"id", "eui", "gateway", "name", "version", "type", "libVersion", "batteryLevel", "eraseConfig", "firmware", "state", "lastSeen"})
    public Node(Integer id, String eui, Gateway gateway, String name, String version, MYCMessages.MESSAGE_TYPE_PRESENTATION type, String libVersion, String batteryLevel, Boolean eraseConfig, Firmware firmware, AppProperties.STATE state, Long lastSeen) {
        this.id = id;
        this.eui = eui;
        this.gateway = gateway;
        this.name = name;
        this.version = version;
        this.type = type;
        this.libVersion = libVersion;
        this.batteryLevel = batteryLevel;
        this.eraseConfig = eraseConfig;
        this.firmware = firmware;
        this.state = state;
        this.lastSeen = lastSeen;
    }

    public String toString() {
        return "Node(id=" + this.getId() + ", eui=" + this.getEui() + ", gateway=" + this.getGateway() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", type=" + (Object)((Object)this.getType()) + ", libVersion=" + this.getLibVersion() + ", batteryLevel=" + this.getBatteryLevel() + ", eraseConfig=" + this.getEraseConfig() + ", firmware=" + this.getFirmware() + ", state=" + (Object)((Object)this.getState()) + ", lastSeen=" + this.getLastSeen() + ")";
    }

    public static class NodeBuilder {
        private Integer id;
        private String eui;
        private Gateway gateway;
        private String name;
        private String version;
        private MYCMessages.MESSAGE_TYPE_PRESENTATION type;
        private String libVersion;
        private String batteryLevel;
        private Boolean eraseConfig;
        private Firmware firmware;
        private AppProperties.STATE state;
        private Long lastSeen;

        NodeBuilder() {
        }

        public NodeBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public NodeBuilder eui(String eui) {
            this.eui = eui;
            return this;
        }

        public NodeBuilder gateway(Gateway gateway) {
            this.gateway = gateway;
            return this;
        }

        public NodeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NodeBuilder version(String version) {
            this.version = version;
            return this;
        }

        public NodeBuilder type(MYCMessages.MESSAGE_TYPE_PRESENTATION type) {
            this.type = type;
            return this;
        }

        public NodeBuilder libVersion(String libVersion) {
            this.libVersion = libVersion;
            return this;
        }

        public NodeBuilder batteryLevel(String batteryLevel) {
            this.batteryLevel = batteryLevel;
            return this;
        }

        public NodeBuilder eraseConfig(Boolean eraseConfig) {
            this.eraseConfig = eraseConfig;
            return this;
        }

        public NodeBuilder firmware(Firmware firmware) {
            this.firmware = firmware;
            return this;
        }

        public NodeBuilder state(AppProperties.STATE state) {
            this.state = state;
            return this;
        }

        public NodeBuilder lastSeen(Long lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public Node build() {
            return new Node(this.id, this.eui, this.gateway, this.name, this.version, this.type, this.libVersion, this.batteryLevel, this.eraseConfig, this.firmware, this.state, this.lastSeen);
        }

        public String toString() {
            return "Node.NodeBuilder(id=" + this.id + ", eui=" + this.eui + ", gateway=" + this.gateway + ", name=" + this.name + ", version=" + this.version + ", type=" + (Object)((Object)this.type) + ", libVersion=" + this.libVersion + ", batteryLevel=" + this.batteryLevel + ", eraseConfig=" + this.eraseConfig + ", firmware=" + this.firmware + ", state=" + (Object)((Object)this.state) + ", lastSeen=" + this.lastSeen + ")";
        }
    }
}

