/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.UidTagDao;
import org.mycontroller.standalone.db.tables.UidTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidTagDaoImpl
extends BaseAbstractDaoImpl<UidTag, Integer>
implements UidTagDao {
    private static final Logger _logger = LoggerFactory.getLogger(UidTagDaoImpl.class);

    public UidTagDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, UidTag.class);
    }

    @Override
    public void create(UidTag uidTag) {
        try {
            Integer count = this.getDao().create((Object)uidTag);
            _logger.debug("Created UidTag:[{}], Create count:{}", (Object)uidTag, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add UidTag:[{}]", (Object)uidTag, (Object)ex);
        }
    }

    @Override
    public void delete(int id) {
        UidTag uidTag = new UidTag(id);
        try {
            int count = this.getDao().delete((Object)uidTag);
            _logger.debug("UidTag:[{}] deleted, Delete count:{}", (Object)uidTag, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete UidTag:[{}]", (Object)uidTag, (Object)ex);
        }
    }

    @Override
    public void deleteBySensorRefId(int sensorRefId) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("sensor_ref_id", (Object)sensorRefId);
            int deleteCount = deleteBuilder.delete();
            _logger.debug("Deleted sensorRefId:[{}], delete count:{}", (Object)sensorRefId, (Object)deleteCount);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete sensorRefId:{}", (Object)sensorRefId, (Object)ex);
        }
    }

    @Override
    public List<UidTag> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public UidTag get(int uid) {
        try {
            return (UidTag)this.getDao().queryForId((Object)uid);
        }
        catch (SQLException ex) {
            _logger.error("unable to fetch uid:[{}]", (Object)uid, (Object)ex);
            return null;
        }
    }

    @Override
    public UidTag getBySensorRefId(int sensorRefId) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("sensor_ref_id", (Object)sensorRefId);
            return (UidTag)queryBuilder.queryForFirst();
        }
        catch (SQLException ex) {
            _logger.error("unable to fetch uid:[{}]", (Object)sensorRefId, (Object)ex);
            return null;
        }
    }
}

