/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.db.DbException;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.SensorsVariablesMapDao;
import org.mycontroller.standalone.db.tables.SensorsVariablesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorsVariablesMapDaoImpl
extends BaseAbstractDaoImpl<SensorsVariablesMap, Integer>
implements SensorsVariablesMapDao {
    private static final Logger _logger = LoggerFactory.getLogger(SensorsVariablesMapDaoImpl.class);

    public SensorsVariablesMapDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, SensorsVariablesMap.class);
    }

    @Override
    public void create(SensorsVariablesMap sensorsVariablesMap) {
        try {
            Integer count = this.getDao().create((Object)sensorsVariablesMap);
            _logger.debug("Created SensorsVariablesMap:[{}], Create count:{}", (Object)sensorsVariablesMap, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add SensorsVariablesMap:[{}]", (Object)sensorsVariablesMap, (Object)ex);
        }
    }

    @Override
    public void create(MYCMessages.MESSAGE_TYPE_PRESENTATION sensorType, MYCMessages.MESSAGE_TYPE_SET_REQ variableType) {
        this.create(SensorsVariablesMap.builder().sensorType(sensorType).variableType(variableType).build());
    }

    @Override
    public void delete(SensorsVariablesMap sensorsVariablesMap) {
        try {
            int deleteCount = this.getDao().delete((Object)sensorsVariablesMap);
            _logger.debug("Deleted sensorsVariablesType:[{}], delete count:{}", (Object)sensorsVariablesMap, (Object)deleteCount);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete, sensorsVariablesMap:{}", (Object)sensorsVariablesMap, (Object)ex);
        }
    }

    @Override
    public void delete(MYCMessages.MESSAGE_TYPE_PRESENTATION sensorType) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("sensorType", (Object)sensorType);
            int deleteCount = deleteBuilder.delete();
            _logger.debug("Deleted sensorType:[{}], delete count:{}", (Object)sensorType, (Object)deleteCount);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete, sensorType:{}", (Object)sensorType, (Object)ex);
        }
    }

    @Override
    public List<SensorsVariablesMap> getAll(MYCMessages.MESSAGE_TYPE_PRESENTATION sensorType) {
        try {
            if (sensorType == null) {
                return null;
            }
            return this.getDao().queryForEq("sensorType", (Object)sensorType);
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list wit sensorType:{}", (Object)sensorType, (Object)ex);
            return null;
        }
    }

    @Override
    public List<SensorsVariablesMap> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public SensorsVariablesMap get(MYCMessages.MESSAGE_TYPE_PRESENTATION sensorType, MYCMessages.MESSAGE_TYPE_SET_REQ variableType) {
        try {
            this.nodeIdSensorIdnullCheck(sensorType, variableType);
            return (SensorsVariablesMap)this.getDao().queryForFirst(this.getDao().queryBuilder().where().eq("sensorType", (Object)sensorType).and().eq("variableType", (Object)variableType).prepare());
        }
        catch (SQLException ex) {
            _logger.error("unable to get", (Throwable)ex);
        }
        catch (DbException dbEx) {
            _logger.error("unable to get, sensorType:{},variableType:{}", new Object[]{sensorType, variableType, dbEx});
        }
        return null;
    }

    @Override
    public SensorsVariablesMap get(SensorsVariablesMap sensorsVariablesMap) {
        try {
            if (sensorsVariablesMap.getId() != null) {
                return (SensorsVariablesMap)this.getDao().queryForId((Object)sensorsVariablesMap.getId());
            }
            return this.get(sensorsVariablesMap.getSensorType(), sensorsVariablesMap.getVariableType());
        }
        catch (SQLException ex) {
            _logger.error("unable to get", (Throwable)ex);
            return null;
        }
    }

    private void nodeIdSensorIdnullCheck(MYCMessages.MESSAGE_TYPE_PRESENTATION sensorType, MYCMessages.MESSAGE_TYPE_SET_REQ variableType) throws DbException {
        if (sensorType != null && variableType != null) {
            return;
        }
        throw new DbException("sensorType or NodeId should not be a NULL, sensorType:" + (Object)((Object)sensorType) + ",variableType:" + (Object)((Object)variableType));
    }
}

