/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.MetricsBinaryTypeDeviceDao;
import org.mycontroller.standalone.db.tables.MetricsBinaryTypeDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsBinaryTypeDeviceDaoImpl
extends BaseAbstractDaoImpl<MetricsBinaryTypeDevice, Object>
implements MetricsBinaryTypeDeviceDao {
    private static final Logger _logger = LoggerFactory.getLogger(MetricsBinaryTypeDeviceDaoImpl.class);

    public MetricsBinaryTypeDeviceDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, MetricsBinaryTypeDevice.class);
    }

    @Override
    public void deleteBySensorValueRefId(int sensorValueRefId) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("sensorVariableId", (Object)sensorValueRefId);
            int count = deleteBuilder.delete();
            _logger.debug("Metric-sensorValueRefId:[{}] deleted, Delete count:{}", (Object)sensorValueRefId, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete metric-sensorValueRefId:[{}]", (Object)sensorValueRefId, (Object)ex);
        }
    }

    @Override
    public void deletePrevious(MetricsBinaryTypeDevice metric) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().lt("timestamp", (Object)metric.getTimestamp());
            int count = this.getDao().delete(deleteBuilder.prepare());
            _logger.debug("Metric:[{}] deleted, Delete count:{}", (Object)metric, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete metric:[{}]", (Object)metric, (Object)ex);
        }
    }

    @Override
    public List<MetricsBinaryTypeDevice> getAll(MetricsBinaryTypeDevice metric) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            Where where = queryBuilder.where();
            where.eq("sensorVariableId", (Object)metric.getSensorVariable().getId());
            if (metric.getTimestampFrom() != null) {
                where.and().ge("timestamp", (Object)metric.getTimestampFrom());
            }
            if (metric.getTimestampTo() != null) {
                where.and().le("timestamp", (Object)metric.getTimestampTo());
            }
            return queryBuilder.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get, metric:{}", (Object)metric, (Object)ex);
            return null;
        }
    }

    @Override
    public MetricsBinaryTypeDevice get(MetricsBinaryTypeDevice metric) {
        try {
            return (MetricsBinaryTypeDevice)this.getDao().queryForFirst(this.getDao().queryBuilder().where().eq("sensorVariableId", (Object)metric.getSensorVariable().getId()).and().eq("timestamp", (Object)metric.getTimestamp()).prepare());
        }
        catch (SQLException ex) {
            _logger.error("unable to get, metric:{}", (Object)metric, (Object)ex);
            return null;
        }
    }

    @Override
    public List<MetricsBinaryTypeDevice> getAll(List<Object> ids) {
        return null;
    }
}

