/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db;

import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.db.PayloadOperation;

public class PayloadOperationUtils {
    private PayloadOperationUtils() {
    }

    public static synchronized String getPayload(PayloadOperation specialOperation, String orginalValue) {
        String revisedValue;
        if (orginalValue == null) {
            orginalValue = "0";
        }
        switch (specialOperation.getOperationType()) {
            case TOGGLE: {
                revisedValue = NumericUtils.getDoubleAsString(Double.valueOf(orginalValue) > 0.0 ? 0.0 : 1.0);
                break;
            }
            case INCREMENT: {
                revisedValue = NumericUtils.getDoubleAsString(Double.valueOf(orginalValue) + 1.0);
                break;
            }
            case DECREMENT: {
                revisedValue = NumericUtils.getDoubleAsString(Double.valueOf(orginalValue) - 1.0);
                break;
            }
            case ADD: {
                revisedValue = NumericUtils.getDoubleAsString(Double.valueOf(orginalValue) + specialOperation.getValue());
                break;
            }
            case SUBTRACT: {
                revisedValue = NumericUtils.getDoubleAsString(Double.valueOf(orginalValue) - specialOperation.getValue());
                break;
            }
            case MULTIPLIE: {
                revisedValue = NumericUtils.getDoubleAsString(Double.valueOf(orginalValue) * specialOperation.getValue());
                break;
            }
            case DIVIDE: {
                revisedValue = NumericUtils.getDoubleAsString(Double.valueOf(orginalValue) / specialOperation.getValue());
                break;
            }
            case MODULUS: {
                revisedValue = NumericUtils.getDoubleAsString(Double.valueOf(orginalValue) % specialOperation.getValue());
                break;
            }
            case REBOOT: {
                revisedValue = specialOperation.getOperationType().getText();
                break;
            }
            default: {
                revisedValue = null;
            }
        }
        return revisedValue;
    }

    public static enum SEND_PAYLOAD_OPERATIONS {
        TOGGLE("toggle"),
        INCREMENT("++"),
        DECREMENT("--"),
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLIE("*"),
        DIVIDE("/"),
        MODULUS("%"),
        START("start"),
        STOP("stop"),
        REBOOT("reboot"),
        RELOAD("reload"),
        ENABLE("enable"),
        DISABLE("disable");

        private String value;

        public static SEND_PAYLOAD_OPERATIONS get(int id) {
            for (SEND_PAYLOAD_OPERATIONS type : SEND_PAYLOAD_OPERATIONS.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        private SEND_PAYLOAD_OPERATIONS(String value) {
            this.value = value;
        }

        public String getText() {
            return this.value;
        }

        public static SEND_PAYLOAD_OPERATIONS fromString(String text) {
            if (text != null) {
                for (SEND_PAYLOAD_OPERATIONS type : SEND_PAYLOAD_OPERATIONS.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

