/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.api.jaxrs.exception.mappers.VariableStatusModel;
import org.mycontroller.standalone.api.jaxrs.mapper.KeyValueJson;
import org.mycontroller.standalone.api.jaxrs.mapper.PayloadJson;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.DeleteResourceUtils;
import org.mycontroller.standalone.db.SensorUtils;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rest/sensors")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"user"})
public class SensorHandler {
    private static final Logger _logger = LoggerFactory.getLogger(SensorHandler.class);

    @GET
    @Path(value="/")
    public Response getAllSensors(@QueryParam(value="nodeId") Integer nodeId, @QueryParam(value="nodeName") String nodeName, @QueryParam(value="type") String type, @QueryParam(value="sensorId") Integer sensorId, @QueryParam(value="name") List<String> name, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("nodeId", nodeId);
        filters.put("type", (Object)MYCMessages.MESSAGE_TYPE_PRESENTATION.fromString(type));
        filters.put("sensorId", sensorId);
        filters.put("name", name);
        QueryResponse queryResponse = DaoUtils.getSensorDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") Integer id) {
        Sensor sensor = (Sensor)DaoUtils.getSensorDao().getById(id);
        return RestUtils.getResponse(Response.Status.OK, sensor);
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Integer id) {
        DeleteResourceUtils.deleteSensor(id);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @POST
    @Path(value="/deleteIds")
    public Response deleteIds(List<Integer> ids) {
        DeleteResourceUtils.deleteSensors(ids);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @PUT
    @Path(value="/")
    public Response update(Sensor sensor) {
        Node node = DaoUtils.getNodeDao().get(sensor.getNode().getId());
        ObjectFactory.getIActionEngine(node.getGateway().getNetworkType()).updateSensor(sensor);
        SensorUtils.updateSensorVariables(sensor);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @POST
    @Path(value="/")
    public Response add(Sensor sensor) {
        List<String> variableTypes = sensor.getVariableTypes();
        Node node = DaoUtils.getNodeDao().get(sensor.getNode().getId());
        ObjectFactory.getIActionEngine(node.getGateway().getNetworkType()).addSensor(sensor);
        sensor = DaoUtils.getSensorDao().get(sensor.getNode().getId(), sensor.getSensorId());
        for (String variableType : variableTypes) {
            DaoUtils.getSensorVariableDao().create(SensorVariable.builder().sensor(sensor).variableType(MYCMessages.MESSAGE_TYPE_SET_REQ.fromString(variableType)).build().updateUnitAndMetricType());
        }
        return RestUtils.getResponse(Response.Status.CREATED);
    }

    @PUT
    @Path(value="/updateVariable")
    public Response sendpayload(VariableStatusModel variableStatusModel) {
        SensorVariable sensorVariable = DaoUtils.getSensorVariableDao().get(variableStatusModel.getId());
        if (sensorVariable == null) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST);
        }
        sensorVariable.setValue(String.valueOf(variableStatusModel.getValue()));
        ObjectFactory.getIActionEngine(sensorVariable.getSensor().getNode().getGateway().getNetworkType()).sendPayload(sensorVariable);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @PUT
    @Path(value="/updateOthers/{sensorRefId}")
    public Response update(@PathParam(value="sensorRefId") int sensorRefId, List<KeyValueJson> keyValues) {
        SensorUtils.updateOthers(sensorRefId, keyValues);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @GET
    @Path(value="/getOthers/{sensorRefId}")
    public Response get(@PathParam(value="sensorRefId") int sensorRefId) {
        return RestUtils.getResponse(Response.Status.OK, SensorUtils.getOthers(sensorRefId));
    }

    @POST
    @Path(value="/sendPayload")
    public Response sendPayload(PayloadJson payload) {
        _logger.debug("PayloadJson:{}", (Object)payload);
        Sensor sensor = null;
        if (payload.getButtonType() != null) {
            sensor = (Sensor)DaoUtils.getSensorDao().getById(payload.getSensorRefId());
            switch (PayloadJson.BUTTON_TYPE.valueOf(payload.getButtonType().toUpperCase())) {
                case ON_OFF: {
                    payload.setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ.V_STATUS);
                    break;
                }
                case LOCK_UNLOCK: {
                    payload.setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ.V_LOCK_STATUS);
                    break;
                }
                case ARMED: {
                    payload.setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ.V_ARMED);
                    break;
                }
                case TRIPPED: {
                    payload.setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ.V_TRIPPED);
                    break;
                }
                case INCREASE: {
                    SensorVariable sensorVariable = DaoUtils.getSensorVariableDao().get(sensor.getId(), payload.getVariableType());
                    if (sensorVariable != null && sensorVariable.getValue() != null) {
                        payload.setPayload(String.valueOf(NumericUtils.getDouble(sensorVariable.getValue()) + 1.0));
                        break;
                    }
                    payload.setPayload("0");
                    break;
                }
                case DECREASE: {
                    SensorVariable sensorVariable = DaoUtils.getSensorVariableDao().get(sensor.getId(), payload.getVariableType());
                    if (sensorVariable != null && sensorVariable.getValue() != null) {
                        payload.setPayload(String.valueOf(NumericUtils.getDouble(sensorVariable.getValue()) - 1.0));
                        break;
                    }
                    payload.setPayload("0");
                    break;
                }
                case UP: {
                    payload.setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ.V_UP);
                    break;
                }
                case DOWN: {
                    payload.setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ.V_DOWN);
                    break;
                }
                case STOP: {
                    payload.setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ.V_STOP);
                    break;
                }
                case RGB: {
                    payload.setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ.V_RGB);
                    payload.setPayload(payload.getPayload().replace("#", ""));
                    break;
                }
                case RGBW: {
                    payload.setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ.V_RGBW);
                    payload.setPayload(SensorUtils.getHexFromRgba(payload.getPayload()));
                    break;
                }
            }
        } else {
            sensor = DaoUtils.getSensorDao().get(payload.getNodeId(), payload.getSensorId());
        }
        ObjectFactory.getIActionEngine(sensor.getNode().getGateway().getNetworkType()).sendPayload(sensor, payload);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="sensorVariable/{id}")
    public Response getSensorValue(@PathParam(value="id") int id) {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getSensorVariableDao().get(id));
    }
}

