/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.DeleteResourceUtils;
import org.mycontroller.standalone.db.tables.ResourcesGroup;
import org.mycontroller.standalone.db.tables.ResourcesGroupMap;
import org.mycontroller.standalone.group.ResourcesGroupUtils;

@Path(value="/rest/resources/group")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"user"})
public class ResourcesGroupHandler {
    @PUT
    @Path(value="/")
    public Response updateResourcesGroup(ResourcesGroup resourcesGroup) {
        DaoUtils.getResourcesGroupDao().update(resourcesGroup);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/")
    public Response addResourcesGroup(ResourcesGroup resourcesGroup) {
        DaoUtils.getResourcesGroupDao().create(resourcesGroup);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/{groupId}")
    public Response getResourcesGroup(@PathParam(value="groupId") Integer groupId) {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getResourcesGroupDao().get(groupId));
    }

    @GET
    @Path(value="/")
    public Response getAllResourcesGroups(@QueryParam(value="name") List<String> name, @QueryParam(value="description") List<String> description, @QueryParam(value="state") String state, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("name", name);
        filters.put("description", description);
        filters.put("state", (Object)AppProperties.STATE.fromString(state));
        QueryResponse queryResponse = DaoUtils.getResourcesGroupDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @POST
    @Path(value="/delete")
    public Response deleteResourcesGroup(List<Integer> ids) {
        DeleteResourceUtils.deleteResourcesGroup(ids);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/on")
    public Response onResourcesGroup(List<Integer> ids) {
        ResourcesGroupUtils.turnONresourcesGroup(ids);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/off")
    public Response offResourcesGroup(List<Integer> ids) {
        ResourcesGroupUtils.turnOFFresourcesGroup(ids);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @PUT
    @Path(value="/map/")
    public Response updateResourcesGroupMap(ResourcesGroupMap resourcesGroupMap) {
        DaoUtils.getResourcesGroupMapDao().update(resourcesGroupMap);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/map/")
    public Response addResourcesGroupMap(ResourcesGroupMap resourcesGroupMap) {
        DaoUtils.getResourcesGroupMapDao().createOrUpdate(resourcesGroupMap);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/map/{id}")
    public Response getResourcesGroupMap(@PathParam(value="id") Integer id) {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getResourcesGroupMapDao().get(id));
    }

    @GET
    @Path(value="/map")
    public Response getAllResourcesGroupsMap(@QueryParam(value="groupId") Integer groupId, @QueryParam(value="payloadOn") List<String> payloadOn, @QueryParam(value="payloadOff") List<String> payloadOff, @QueryParam(value="resourceType") String resourceType, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("groupId", groupId);
        filters.put("payloadOn", payloadOn);
        filters.put("payloadOff", payloadOff);
        filters.put("resourceType", (Object)AppProperties.RESOURCE_TYPE.fromString(resourceType));
        QueryResponse queryResponse = DaoUtils.getResourcesGroupMapDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @POST
    @Path(value="/map/delete")
    public Response deleteResourcesGroupMap(List<Integer> ids) {
        DaoUtils.getResourcesGroupMapDao().delete(ids);
        return RestUtils.getResponse(Response.Status.OK);
    }
}

