/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.api.jaxrs.mapper.ApiError;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.DeleteResourceUtils;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.gateway.GatewayUtils;

@Path(value="/rest/gateways")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"user"})
public class GatewayHandler {
    @PUT
    @Path(value="/")
    public Response updateGateway(Gateway gateway) {
        GatewayUtils.updateGateway(gateway);
        return RestUtils.getResponse(Response.Status.ACCEPTED);
    }

    @POST
    @Path(value="/")
    public Response addGateway(Gateway gateway) {
        GatewayUtils.addGateway(gateway);
        return RestUtils.getResponse(Response.Status.ACCEPTED);
    }

    @GET
    @Path(value="/{id}")
    public Response getGateway(@PathParam(value="id") Integer gatewayId) {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getGatewayDao().getById(gatewayId));
    }

    @GET
    @Path(value="/")
    public Response getAllGateways(@QueryParam(value="name") List<String> name, @QueryParam(value="networkType") String networkType, @QueryParam(value="type") String type, @QueryParam(value="state") String state, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("name", name);
        filters.put("networkType", (Object)AppProperties.NETWORK_TYPE.fromString(networkType));
        filters.put("type", (Object)GatewayUtils.TYPE.fromString(type));
        filters.put("state", (Object)AppProperties.STATE.fromString(state));
        QueryResponse queryResponse = DaoUtils.getGatewayDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @POST
    @Path(value="/delete")
    public Response deleteGateways(List<Integer> ids) {
        DeleteResourceUtils.deleteGateways(ids);
        return RestUtils.getResponse(Response.Status.ACCEPTED);
    }

    @POST
    @Path(value="/enable")
    public Response enableGateway(List<Integer> ids) {
        GatewayUtils.enableGateways(ids);
        return RestUtils.getResponse(Response.Status.ACCEPTED);
    }

    @POST
    @Path(value="/disable")
    public Response enableGateways(List<Integer> ids) {
        GatewayUtils.disableGateways(ids);
        return RestUtils.getResponse(Response.Status.ACCEPTED);
    }

    @POST
    @Path(value="/reload")
    public Response reloadGateways(List<Integer> ids) {
        GatewayUtils.reloadGateways(ids);
        return RestUtils.getResponse(Response.Status.ACCEPTED);
    }

    @POST
    @Path(value="/discover")
    public Response executeNodeDiscover(List<Integer> ids) {
        try {
            for (Integer id : ids) {
                Gateway gateway = (Gateway)DaoUtils.getGatewayDao().getById(id);
                if (!gateway.getEnabled().booleanValue()) continue;
                ObjectFactory.getIActionEngine(gateway.getNetworkType()).discover(id);
            }
            return RestUtils.getResponse(Response.Status.OK, new ApiError("Node Discover util started successfully"));
        }
        catch (Exception ex) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError(ex.getMessage()));
        }
    }
}

