/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.DeleteResourceUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;

@Path(value="/rest/alarms")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"admin"})
public class AlarmHandler {
    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") int id) {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getAlarmDefinitionDao().getById(id));
    }

    @GET
    @Path(value="/")
    public Response getAll(@QueryParam(value="name") List<String> name, @QueryParam(value="resourceType") String resourceType, @QueryParam(value="resourceId") Integer resourceId, @QueryParam(value="triggered") Boolean triggered, @QueryParam(value="enabled") Boolean enabled, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("name", name);
        filters.put("resourceType", (Object)AppProperties.RESOURCE_TYPE.fromString(resourceType));
        filters.put("resourceId", resourceId);
        filters.put("triggered", triggered);
        filters.put("enabled", enabled);
        QueryResponse queryResponse = DaoUtils.getAlarmDefinitionDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @POST
    @Path(value="/")
    public Response add(AlarmDefinition alarmDefinition) {
        alarmDefinition.setTimestamp(System.currentTimeMillis());
        DaoUtils.getAlarmDefinitionDao().create(alarmDefinition);
        return RestUtils.getResponse(Response.Status.CREATED);
    }

    @PUT
    @Path(value="/")
    public Response update(AlarmDefinition alarmDefinition) {
        alarmDefinition.setTimestamp(System.currentTimeMillis());
        alarmDefinition.setTriggered(false);
        alarmDefinition.setDampeningInternal1(null);
        alarmDefinition.setDampeningInternal2(null);
        switch (alarmDefinition.getDampeningType()) {
            case NONE: {
                alarmDefinition.setDampeningVar1(null);
                alarmDefinition.setDampeningVar2(null);
                break;
            }
            case CONSECUTIVE: {
                alarmDefinition.setDampeningVar2(null);
                break;
            }
            case LAST_N_EVALUATIONS: {
                break;
            }
        }
        DaoUtils.getAlarmDefinitionDao().update(alarmDefinition);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @POST
    @Path(value="/delete")
    public Response deleteIds(List<Integer> ids) {
        DeleteResourceUtils.deleteAlarmDefinitions(ids);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @POST
    @Path(value="/enable")
    public Response enableIds(List<Integer> ids) {
        AlarmUtils.enableAlarmDefinitions(ids);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @POST
    @Path(value="/disable")
    public Response disableIds(List<Integer> ids) {
        AlarmUtils.disableAlarmDefinitions(ids);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }
}

