/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.alarm.jobs;

import com.xeiam.sundial.Job;
import com.xeiam.sundial.exceptions.JobInterruptException;
import java.util.List;
import org.mycontroller.standalone.alarm.AlarmEngine;
import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmDefinitionDampeningActiveTimeJob
extends Job {
    private static boolean isRunning = false;
    private static final Logger _logger = LoggerFactory.getLogger((String)AlarmDefinitionDampeningActiveTimeJob.class.getName());

    public void doRun() throws JobInterruptException {
        if (isRunning) {
            _logger.warn("Previous run of 'Alarm definition dampening active time job' is not completed! Terminating this job...");
        }
        isRunning = true;
        try {
            List<AlarmDefinition> activeTimeDefinitions = DaoUtils.getAlarmDefinitionDao().getAll(AlarmUtils.DAMPENING_TYPE.ACTIVE_TIME);
            _logger.debug("Number of definitions:{}, Alarm definitions:{}", (Object)activeTimeDefinitions.size(), activeTimeDefinitions);
            AlarmEngine.builder().alarmDefinitions(activeTimeDefinitions).build().run();
        }
        catch (Exception ex) {
            _logger.error("Unable to run alarm dampening active time definitions, ", (Throwable)ex);
        }
        isRunning = false;
    }
}

