/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.alarm;

import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.alarm.IDampening;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;

public class DampeningLastNEvaluations
implements IDampening {
    private int occurrencesMax;
    private int evaluationsMax;
    private int occurrencesCount;
    private int evaluationsCount;
    private AlarmDefinition alarmDefinition;

    public DampeningLastNEvaluations(AlarmDefinition alarmDefinition) {
        this.alarmDefinition = alarmDefinition;
        this.occurrencesMax = Integer.valueOf(alarmDefinition.getDampeningVar1());
        this.evaluationsMax = Integer.valueOf(alarmDefinition.getDampeningVar2());
        this.occurrencesCount = alarmDefinition.getDampeningInternal1() == null ? 0 : Integer.valueOf(alarmDefinition.getDampeningInternal1());
        this.evaluationsCount = alarmDefinition.getDampeningInternal2() == null ? 0 : Integer.valueOf(alarmDefinition.getDampeningInternal2());
    }

    public int getOccurrencesMax() {
        return this.occurrencesMax;
    }

    public int getEvaluationsMax() {
        return this.evaluationsMax;
    }

    public int getOccurrencesCount() {
        return this.occurrencesCount;
    }

    public void setOccurrencesCount(int occurrencesCount) {
        this.occurrencesCount = occurrencesCount;
    }

    public int getEvaluationsCount() {
        return this.evaluationsCount;
    }

    public void setEvaluationsCount(int evaluationsCount) {
        this.evaluationsCount = evaluationsCount;
    }

    public void incrementOccurrencesCount() {
        ++this.occurrencesCount;
    }

    public void incrementEvaluationsCount() {
        ++this.evaluationsCount;
    }

    @Override
    public void reset() {
        this.occurrencesCount = 0;
        this.evaluationsCount = 0;
        this.update();
    }

    @Override
    public void update() {
        this.alarmDefinition.setDampeningInternal1(String.valueOf(this.occurrencesCount));
        this.alarmDefinition.setDampeningInternal1(String.valueOf(this.evaluationsCount));
        DaoUtils.getAlarmDefinitionDao().update(this.alarmDefinition);
    }

    @Override
    public boolean evaluate() {
        return this.evaluationsCount >= this.evaluationsMax && this.occurrencesCount >= this.occurrencesMax;
    }

    public boolean isExecutable() {
        return this.evaluationsCount >= this.evaluationsMax;
    }

    @Override
    public AlarmDefinition getAlarmDefinition() {
        return this.alarmDefinition;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(AlarmUtils.DAMPENING_TYPE.CONSECUTIVE.getText());
        builder.append("=").append("occurrencesCount:").append(this.occurrencesCount);
        builder.append(", occurrencesMax:").append(this.occurrencesMax);
        builder.append(", evaluationsCount:").append(this.evaluationsCount);
        builder.append(", evaluationsMax:").append(this.evaluationsMax);
        return builder.toString();
    }
}

