/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.settings;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.settings.SettingsUtils;

@JsonTypeName(value="emailSettings")
public class EmailSettings {
    public static final String KEY_EMAIL = "email";
    public static final String SKEY_SMTP_HOST = "smtpHost";
    public static final String SKEY_SMTP_PORT = "smtpPort";
    public static final String SKEY_FROM_ADDRESS = "fromAddress";
    public static final String SKEY_ENABLE_SSL = "enableSsl";
    public static final String SKEY_SMTP_USERNAME = "smtpUsername";
    public static final String SKEY_SMTP_PASSWORD = "smtpPassword";
    private String smtpHost;
    private Integer smtpPort;
    private String fromAddress;
    private Boolean enableSsl;
    private String smtpUsername;
    private String smtpPassword;

    public static EmailSettings get() {
        return EmailSettings.builder().smtpHost(EmailSettings.getValue(SKEY_SMTP_HOST)).smtpPort(NumericUtils.getInteger(EmailSettings.getValue(SKEY_SMTP_PORT))).fromAddress(EmailSettings.getValue(SKEY_FROM_ADDRESS)).enableSsl(NumericUtils.getBoolean(EmailSettings.getValue(SKEY_ENABLE_SSL))).smtpUsername(EmailSettings.getValue(SKEY_SMTP_USERNAME)).smtpPassword(EmailSettings.getValue(SKEY_SMTP_PASSWORD)).build();
    }

    public void save() {
        this.updateValue(SKEY_SMTP_HOST, this.smtpHost);
        this.updateValue(SKEY_SMTP_PORT, this.smtpPort);
        this.updateValue(SKEY_FROM_ADDRESS, this.fromAddress);
        this.updateValue(SKEY_ENABLE_SSL, this.enableSsl);
        this.updateValue(SKEY_SMTP_USERNAME, this.smtpUsername);
        this.updateValue(SKEY_SMTP_PASSWORD, this.smtpPassword);
    }

    private static String getValue(String subKey) {
        return SettingsUtils.getValue(KEY_EMAIL, subKey);
    }

    private void updateValue(String subKey, Object value) {
        SettingsUtils.updateValue(KEY_EMAIL, subKey, value);
    }

    public static EmailSettingsBuilder builder() {
        return new EmailSettingsBuilder();
    }

    public String toString() {
        return "EmailSettings(smtpHost=" + this.getSmtpHost() + ", smtpPort=" + this.getSmtpPort() + ", fromAddress=" + this.getFromAddress() + ", enableSsl=" + this.getEnableSsl() + ", smtpUsername=" + this.getSmtpUsername() + ", smtpPassword=" + this.getSmtpPassword() + ")";
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public Integer getSmtpPort() {
        return this.smtpPort;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public Boolean getEnableSsl() {
        return this.enableSsl;
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public EmailSettings() {
    }

    @ConstructorProperties(value={"smtpHost", "smtpPort", "fromAddress", "enableSsl", "smtpUsername", "smtpPassword"})
    public EmailSettings(String smtpHost, Integer smtpPort, String fromAddress, Boolean enableSsl, String smtpUsername, String smtpPassword) {
        this.smtpHost = smtpHost;
        this.smtpPort = smtpPort;
        this.fromAddress = fromAddress;
        this.enableSsl = enableSsl;
        this.smtpUsername = smtpUsername;
        this.smtpPassword = smtpPassword;
    }

    public static class EmailSettingsBuilder {
        private String smtpHost;
        private Integer smtpPort;
        private String fromAddress;
        private Boolean enableSsl;
        private String smtpUsername;
        private String smtpPassword;

        EmailSettingsBuilder() {
        }

        public EmailSettingsBuilder smtpHost(String smtpHost) {
            this.smtpHost = smtpHost;
            return this;
        }

        public EmailSettingsBuilder smtpPort(Integer smtpPort) {
            this.smtpPort = smtpPort;
            return this;
        }

        public EmailSettingsBuilder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public EmailSettingsBuilder enableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        public EmailSettingsBuilder smtpUsername(String smtpUsername) {
            this.smtpUsername = smtpUsername;
            return this;
        }

        public EmailSettingsBuilder smtpPassword(String smtpPassword) {
            this.smtpPassword = smtpPassword;
            return this;
        }

        public EmailSettings build() {
            return new EmailSettings(this.smtpHost, this.smtpPort, this.fromAddress, this.enableSsl, this.smtpUsername, this.smtpPassword);
        }

        public String toString() {
            return "EmailSettings.EmailSettingsBuilder(smtpHost=" + this.smtpHost + ", smtpPort=" + this.smtpPort + ", fromAddress=" + this.fromAddress + ", enableSsl=" + this.enableSsl + ", smtpUsername=" + this.smtpUsername + ", smtpPassword=" + this.smtpPassword + ")";
        }
    }
}

