/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.mysensors.firmware;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Firmware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareUtils {
    private static final Logger _logger = LoggerFactory.getLogger(FirmwareUtils.class);
    public static final int FIRMWARE_BLOCK_SIZE = 16;

    private FirmwareUtils() {
    }

    public static Firmware getFirmware(String fileName) {
        return FirmwareUtils.getFirmware(new File(fileName));
    }

    public static void updateFirmwareFromHexString(Firmware firmware) {
        if (firmware != null && firmware.getFileString() != null) {
            FirmwareUtils.getFirmware(new BufferedReader(new StringReader(firmware.getFileString())), firmware);
        } else {
            _logger.warn("Invalid Firmware! [{}]", (Object)firmware);
        }
    }

    public static Firmware getFirmware(File file) {
        try {
            return FirmwareUtils.getFirmware(new BufferedReader(new FileReader(file)), null);
        }
        catch (FileNotFoundException ex) {
            _logger.warn("Invalid File!", (Throwable)ex);
            return null;
        }
    }

    public static Firmware getFirmware(BufferedReader reader, Firmware firmware) {
        try {
            String line;
            int start = 0;
            int end = 0;
            ArrayList<Byte> fwdata = new ArrayList<Byte>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                while (!line.substring(0, 1).endsWith(":")) {
                    line = line.substring(1);
                }
                int reclen = Integer.parseInt(line.substring(1, 3), 16);
                int offset = Integer.parseInt(line.substring(3, 7), 16);
                int rectype = Integer.parseInt(line.substring(7, 9), 16);
                String data = line.substring(9, 9 + 2 * reclen);
                if (rectype != 0) continue;
                if (start == 0 && end == 0) {
                    if (offset % 128 > 0) {
                        throw new Error("error loading hex file - offset can't be devided by 128");
                    }
                    start = offset;
                    end = offset;
                }
                if (offset < end) {
                    throw new Error("error loading hex file - offset lower than end");
                }
                while (offset > end) {
                    fwdata.add((byte)-1);
                    ++end;
                }
                for (int i = 0; i < reclen; ++i) {
                    fwdata.add((byte)Integer.parseInt(data.substring(i * 2, i * 2 + 2), 16));
                }
                end += reclen;
            }
            int pad = end % 128;
            for (int i = 0; i < 128 - pad; ++i) {
                fwdata.add((byte)-1);
                ++end;
            }
            int blocks = (end - start) / 16;
            int crc = 65535;
            for (int i = 0; i < blocks * 16; ++i) {
                crc = FirmwareUtils.crcUpdate(crc, (Byte)fwdata.get(i) & 0xFF);
            }
            if (firmware == null) {
                firmware = new Firmware();
            }
            firmware.setBlocks(blocks);
            firmware.setCrc(crc);
            firmware.setData(fwdata);
            firmware.setFileString(null);
            return firmware;
        }
        catch (IOException ex) {
            _logger.error("Exception, ", (Throwable)ex);
            return null;
        }
    }

    public static int crcUpdate(int old, int value) {
        int c = old ^ value;
        for (int i = 0; i < 8; ++i) {
            if ((c & 1) > 0) {
                c = c >> 1 ^ 0xA001;
                continue;
            }
            c >>= 1;
        }
        return c;
    }

    public static synchronized void deleteFirmwareType(int id) {
        List<Firmware> firmwares = DaoUtils.getFirmwareDao().getAllFirmwareByType(id);
        for (Firmware firmware : firmwares) {
            DaoUtils.getFirmwareDao().delete(firmware);
        }
        DaoUtils.getFirmwareTypeDao().deleteById(id);
    }

    public static synchronized void deleteFirmwareVersion(int id) {
        List<Firmware> firmwares = DaoUtils.getFirmwareDao().getAllFirmwareByVersion(id);
        for (Firmware firmware : firmwares) {
            DaoUtils.getFirmwareDao().delete(firmware);
        }
        DaoUtils.getFirmwareVersionDao().deleteById(id);
    }

    public static synchronized void deleteFirmware(int id) {
        DaoUtils.getFirmwareDao().deleteById(id);
    }

    public static synchronized void createFirmware(Firmware firmware) {
        FirmwareUtils.updateFirmwareFromHexString(firmware);
        firmware.setTimestamp(System.currentTimeMillis());
        DaoUtils.getFirmwareDao().create(firmware);
    }
}

