/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.mysensors;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.NodeIdException;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.alarm.AlarmEngine;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.ResourcesLogsUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.db.tables.Firmware;
import org.mycontroller.standalone.db.tables.ForwardPayload;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.db.tables.MetricsBatteryUsage;
import org.mycontroller.standalone.db.tables.MetricsBinaryTypeDevice;
import org.mycontroller.standalone.db.tables.MetricsDoubleTypeDevice;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.fwpayload.ExecuteForwardPayload;
import org.mycontroller.standalone.gateway.GatewayException;
import org.mycontroller.standalone.message.IMessageProcessEngine;
import org.mycontroller.standalone.message.MessageUtils;
import org.mycontroller.standalone.message.RawMessage;
import org.mycontroller.standalone.message.RawMessageException;
import org.mycontroller.standalone.metrics.MetricsUtils;
import org.mycontroller.standalone.mysensors.MySensorsRawMessage;
import org.mycontroller.standalone.mysensors.MySensorsUtils;
import org.mycontroller.standalone.mysensors.structs.FirmwareConfigRequest;
import org.mycontroller.standalone.mysensors.structs.FirmwareConfigResponse;
import org.mycontroller.standalone.mysensors.structs.FirmwareRequest;
import org.mycontroller.standalone.mysensors.structs.FirmwareResponse;
import org.mycontroller.standalone.uidtag.ExecuteUidTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySensorsMessageEngine
implements IMessageProcessEngine {
    private static final Logger _logger = LoggerFactory.getLogger((String)MySensorsMessageEngine.class.getName());
    private static final int FIRMWARE_PRINT_LOG = 100;
    private Firmware firmware;

    @Override
    public void executeMessage(RawMessage rawMessage) throws GatewayException {
        MySensorsRawMessage mySensorsRawMessage = null;
        try {
            mySensorsRawMessage = new MySensorsRawMessage(rawMessage);
        }
        catch (RawMessageException ex) {
            _logger.error("Exception while parsing RawMessage:[{}]", (Object)rawMessage);
            return;
        }
        if (mySensorsRawMessage.getAck() == 1) {
            _logger.info("This is ack message[{}]", (Object)mySensorsRawMessage);
        }
        if (mySensorsRawMessage.isTxMessage()) {
            if (MYCMessages.MESSAGE_TYPE.C_SET == MYCMessages.MESSAGE_TYPE.get(mySensorsRawMessage.getMessageType()) && (MYCMessages.MESSAGE_TYPE_SET_REQ.V_RGB == MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType()) || MYCMessages.MESSAGE_TYPE_SET_REQ.V_RGBW == MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType())) && mySensorsRawMessage.getPayload().startsWith("#")) {
                mySensorsRawMessage.setPayload(mySensorsRawMessage.getPayload().replaceAll("#", ""));
            }
            MessageUtils.sendMessgaeToGateway(mySensorsRawMessage.getRawMessage());
            _logger.debug("This is Tx Message[{}] sent", (Object)mySensorsRawMessage);
        }
        switch (MYCMessages.MESSAGE_TYPE.get(mySensorsRawMessage.getMessageType())) {
            case C_PRESENTATION: {
                if (mySensorsRawMessage.isTxMessage()) {
                    if (!ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.NOTICE)) break;
                    this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.NOTICE, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE.get(mySensorsRawMessage.getMessageType()).getText(), null);
                    break;
                }
                _logger.debug("Received a 'Presentation' message");
                this.presentationSubMessageTypeSelector(mySensorsRawMessage);
                break;
            }
            case C_SET: {
                _logger.debug("Received a 'Set' message");
                this.recordSetTypeData(mySensorsRawMessage);
                break;
            }
            case C_REQ: {
                _logger.debug("Received a 'Req' message");
                this.responseReqTypeData(mySensorsRawMessage);
                break;
            }
            case C_INTERNAL: {
                _logger.debug("Received a 'Internal' message");
                this.internalSubMessageTypeSelector(mySensorsRawMessage);
                break;
            }
            case C_STREAM: {
                _logger.debug("Received a 'Stream' message");
                this.streamSubMessageTypeSelector(mySensorsRawMessage);
                break;
            }
            default: {
                _logger.warn("Received unknown message type, not able to process further. Message[{}] dropped", (Object)mySensorsRawMessage);
            }
        }
    }

    private void presentationSubMessageTypeSelector(MySensorsRawMessage mySensorsRawMessage) {
        if (mySensorsRawMessage.getChildSensorId() == 255) {
            Node node = this.getNode(mySensorsRawMessage);
            node.setLibVersion(mySensorsRawMessage.getPayload());
            node.setType(MYCMessages.MESSAGE_TYPE_PRESENTATION.get(mySensorsRawMessage.getSubType()));
            this.updateNode(node);
        } else {
            Node node = this.getNode(mySensorsRawMessage);
            Sensor sensor = DaoUtils.getSensorDao().get(node.getId(), mySensorsRawMessage.getChildSensorId());
            if (sensor == null) {
                sensor = Sensor.builder().sensorId(mySensorsRawMessage.getChildSensorId()).type(MYCMessages.MESSAGE_TYPE_PRESENTATION.get(mySensorsRawMessage.getSubType())).name(mySensorsRawMessage.getPayload()).build();
                sensor.setNode(node);
                DaoUtils.getSensorDao().create(sensor);
            } else {
                sensor.setType(MYCMessages.MESSAGE_TYPE_PRESENTATION.get(mySensorsRawMessage.getSubType()));
                sensor.setName(mySensorsRawMessage.getPayload());
                DaoUtils.getSensorDao().update(sensor);
            }
        }
        _logger.debug("Presentation Message[type:{},payload:{}]", (Object)MYCMessages.MESSAGE_TYPE_PRESENTATION.get(mySensorsRawMessage.getSubType()), (Object)mySensorsRawMessage.getPayload());
        if (ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.NOTICE)) {
            this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.NOTICE, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_PRESENTATION.get(mySensorsRawMessage.getSubType()).getText(), null);
        }
    }

    private void internalSubMessageTypeSelector(MySensorsRawMessage mySensorsRawMessage) {
        Node node = this.getNode(mySensorsRawMessage);
        if (ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.NOTICE)) {
            this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.NOTICE, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_INTERNAL.get(mySensorsRawMessage.getSubType()).getText(), null);
        }
        _logger.debug("Message Type:{}", (Object)MYCMessages.MESSAGE_TYPE_INTERNAL.get(mySensorsRawMessage.getSubType()).toString());
        switch (MYCMessages.MESSAGE_TYPE_INTERNAL.get(mySensorsRawMessage.getSubType())) {
            case I_BATTERY_LEVEL: {
                if (mySensorsRawMessage.isTxMessage()) {
                    return;
                }
                _logger.debug("Battery Level:[nodeId:{},Level:{}%]", (Object)mySensorsRawMessage.getNodeEui(), (Object)mySensorsRawMessage.getPayload());
                node.setBatteryLevel(mySensorsRawMessage.getPayload());
                this.updateNode(node);
                MetricsBatteryUsage batteryUsage = MetricsBatteryUsage.builder().node(node).timestamp(System.currentTimeMillis()).value(mySensorsRawMessage.getPayloadDouble()).build();
                DaoUtils.getMetricsBatteryUsageDao().create(batteryUsage);
                break;
            }
            case I_TIME: {
                if (mySensorsRawMessage.isTxMessage()) {
                    return;
                }
                TimeZone timeZone = TimeZone.getDefault();
                long utcTime = System.currentTimeMillis();
                long timeOffset = timeZone.getOffset(utcTime);
                long localTime = utcTime + timeOffset;
                mySensorsRawMessage.setPayload(String.valueOf(localTime / 1000L));
                mySensorsRawMessage.setTxMessage(true);
                _logger.debug("Time Message:[{}]", (Object)mySensorsRawMessage);
                ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
                _logger.debug("Time request resolved.");
                break;
            }
            case I_VERSION: {
                _logger.debug("Gateway version requested by {}! Message:{}", (Object)"MyController.org", (Object)mySensorsRawMessage);
                break;
            }
            case I_ID_REQUEST: {
                try {
                    int nodeId = MySensorsUtils.getNextNodeId(mySensorsRawMessage.getGatewayId());
                    mySensorsRawMessage.setPayload(nodeId);
                    mySensorsRawMessage.setSubType(MYCMessages.MESSAGE_TYPE_INTERNAL.I_ID_RESPONSE.ordinal());
                    mySensorsRawMessage.setTxMessage(true);
                    ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
                    _logger.debug("New Id[{}] sent to node", (Object)nodeId);
                }
                catch (NodeIdException ex) {
                    _logger.error("Unable to generate new node Id,", (Throwable)ex);
                    if (!ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.ERROR)) break;
                    this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.ERROR, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_INTERNAL.get(mySensorsRawMessage.getSubType()).getText(), ex.getMessage());
                }
                break;
            }
            case I_INCLUSION_MODE: {
                _logger.warn("Inclusion mode not supported by this controller! Message:{}", (Object)mySensorsRawMessage);
                break;
            }
            case I_CONFIG: {
                if (mySensorsRawMessage.isTxMessage()) {
                    return;
                }
                mySensorsRawMessage.setPayload(MySensorsUtils.getMetricType());
                mySensorsRawMessage.setTxMessage(true);
                ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
                _logger.debug("Configuration sent as follow[M/I]?:{}", (Object)mySensorsRawMessage.getPayload());
                break;
            }
            case I_LOG_MESSAGE: {
                if (mySensorsRawMessage.isTxMessage()) {
                    return;
                }
                _logger.debug("Node trace-log message[nodeId:{},sensorId:{},message:{}]", new Object[]{mySensorsRawMessage.getNodeEui(), mySensorsRawMessage.getChildSensorId(), mySensorsRawMessage.getPayload()});
                break;
            }
            case I_SKETCH_NAME: {
                if (mySensorsRawMessage.isTxMessage()) {
                    return;
                }
                _logger.debug("Internal Message[type:{},name:{}]", (Object)MYCMessages.MESSAGE_TYPE_INTERNAL.get(mySensorsRawMessage.getSubType()), (Object)mySensorsRawMessage.getPayload());
                node = this.getNode(mySensorsRawMessage);
                node.setName(mySensorsRawMessage.getPayload());
                this.updateNode(node);
                break;
            }
            case I_SKETCH_VERSION: {
                if (mySensorsRawMessage.isTxMessage()) {
                    return;
                }
                _logger.debug("Internal Message[type:{},version:{}]", (Object)MYCMessages.MESSAGE_TYPE_INTERNAL.get(mySensorsRawMessage.getSubType()), (Object)mySensorsRawMessage.getPayload());
                node = this.getNode(mySensorsRawMessage);
                node.setVersion(mySensorsRawMessage.getPayload());
                this.updateNode(node);
                break;
            }
            case I_REBOOT: {
                break;
            }
            case I_GATEWAY_READY: {
                if (mySensorsRawMessage.isTxMessage()) {
                    return;
                }
                _logger.debug("Gateway Ready[nodeId:{},message:{}]", (Object)mySensorsRawMessage.getNodeEui(), (Object)mySensorsRawMessage.getPayload());
                break;
            }
            case I_ID_RESPONSE: {
                _logger.debug("Internal Message, Type:I_ID_RESPONSE[{}]", (Object)mySensorsRawMessage);
                return;
            }
            case I_HEARTBEAT: {
                if (mySensorsRawMessage.isTxMessage()) {
                    return;
                }
                node = this.getNode(mySensorsRawMessage);
                node.setState(AppProperties.STATE.UP);
                this.updateNode(node);
                break;
            }
            default: {
                _logger.warn("Internal Message[type:{},payload:{}], This type may not be supported (or) not implemented yet", (Object)MYCMessages.MESSAGE_TYPE_INTERNAL.get(mySensorsRawMessage.getSubType()), (Object)mySensorsRawMessage.getPayload());
            }
        }
    }

    private void streamSubMessageTypeSelector(MySensorsRawMessage mySensorsRawMessage) {
        switch (MYCMessages.MESSAGE_TYPE_STREAM.get(mySensorsRawMessage.getSubType())) {
            case ST_FIRMWARE_CONFIG_REQUEST: {
                if (ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.NOTICE)) {
                    this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.NOTICE, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_STREAM.get(mySensorsRawMessage.getSubType()).getText(), null);
                }
                this.processFirmwareConfigRequest(mySensorsRawMessage);
                break;
            }
            case ST_FIRMWARE_REQUEST: {
                if (ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.TRACE)) {
                    this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.TRACE, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_STREAM.get(mySensorsRawMessage.getSubType()).getText(), null);
                }
                this.procressFirmwareRequest(mySensorsRawMessage);
                break;
            }
            case ST_FIRMWARE_CONFIG_RESPONSE: {
                if (!ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.NOTICE)) break;
                this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.NOTICE, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_STREAM.get(mySensorsRawMessage.getSubType()).getText(), null);
                break;
            }
            case ST_FIRMWARE_RESPONSE: 
            case ST_IMAGE: 
            case ST_SOUND: {
                if (!ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.TRACE)) break;
                this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.TRACE, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_STREAM.get(mySensorsRawMessage.getSubType()).getText(), null);
                break;
            }
            default: {
                if (ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.WARNING)) {
                    this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.WARNING, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_STREAM.get(mySensorsRawMessage.getSubType()).getText(), null);
                }
                _logger.debug("Stream Message[type:{},payload:{}], This type not be implemented yet", (Object)MYCMessages.MESSAGE_TYPE_STREAM.get(mySensorsRawMessage.getSubType()), (Object)mySensorsRawMessage.getPayload());
            }
        }
    }

    private void procressFirmwareRequest(MySensorsRawMessage mySensorsRawMessage) {
        FirmwareRequest firmwareRequest = new FirmwareRequest();
        try {
            int fromIndex;
            firmwareRequest.setByteBuffer(ByteBuffer.wrap(Hex.decodeHex((char[])mySensorsRawMessage.getPayload().toCharArray())).order(ByteOrder.LITTLE_ENDIAN), 0);
            _logger.debug("Firmware Request:[Type:{},Version:{},Block:{}]", new Object[]{firmwareRequest.getType(), firmwareRequest.getVersion(), firmwareRequest.getBlock()});
            boolean requestFirmwareReload = false;
            if (this.firmware == null) {
                requestFirmwareReload = true;
            } else if (this.firmware != null) {
                if (firmwareRequest.getBlock() == this.firmware.getBlocks() - 1) {
                    requestFirmwareReload = true;
                } else if (firmwareRequest.getType() != this.firmware.getType().getId() || firmwareRequest.getVersion() != this.firmware.getVersion().getId()) {
                    requestFirmwareReload = true;
                }
            } else {
                requestFirmwareReload = true;
            }
            if (requestFirmwareReload) {
                this.firmware = DaoUtils.getFirmwareDao().get(firmwareRequest.getType(), firmwareRequest.getVersion());
                _logger.debug("Firmware reloaded...");
            }
            if (this.firmware == null) {
                _logger.debug("selected firmware type/version not available");
                return;
            }
            FirmwareResponse firmwareResponse = new FirmwareResponse();
            firmwareResponse.setByteBufferPosition(0);
            firmwareResponse.setBlock(firmwareRequest.getBlock());
            firmwareResponse.setVersion(firmwareRequest.getVersion());
            firmwareResponse.setType(firmwareRequest.getType());
            StringBuilder builder = new StringBuilder();
            for (int index = fromIndex = firmwareRequest.getBlock() * 16; index < fromIndex + 16; ++index) {
                builder.append(String.format("%02X", this.firmware.getData().get(index)));
            }
            if (firmwareRequest.getBlock() == 0) {
                this.firmware = null;
                _logger.debug("Firmware unloaded...");
            }
            if ((firmwareRequest.getBlock() % 100 == 0 || firmwareRequest.getBlock() == this.firmware.getBlocks() - 1) && ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.INFO)) {
                this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.INFO, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_STREAM.ST_FIRMWARE_REQUEST.getText(), "Block No: " + firmwareRequest.getBlock());
            }
            mySensorsRawMessage.setTxMessage(true);
            mySensorsRawMessage.setSubType(MYCMessages.MESSAGE_TYPE_STREAM.ST_FIRMWARE_RESPONSE.ordinal());
            mySensorsRawMessage.setPayload(Hex.encodeHexString((byte[])firmwareResponse.getByteBuffer().array()) + builder.toString());
            ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
            _logger.debug("FirmwareRespone:[Type:{},Version:{},Block:{}]", new Object[]{firmwareResponse.getType(), firmwareResponse.getVersion(), firmwareResponse.getBlock()});
            if ((firmwareRequest.getBlock() % 100 == 0 || firmwareRequest.getBlock() == this.firmware.getBlocks() - 1) && ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.INFO)) {
                this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.INFO, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_STREAM.ST_FIRMWARE_RESPONSE.getText(), "Block No:" + firmwareRequest.getBlock());
            }
        }
        catch (DecoderException ex) {
            _logger.error("Exception, ", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFirmwareConfigRequest(MySensorsRawMessage mySensorsRawMessage) {
        FirmwareConfigRequest firmwareConfigRequest = new FirmwareConfigRequest();
        try {
            FirmwareConfigResponse firmwareConfigResponse;
            Firmware firmware;
            block20: {
                firmwareConfigRequest.setByteBuffer(ByteBuffer.wrap(Hex.decodeHex((char[])mySensorsRawMessage.getPayload().toCharArray())).order(ByteOrder.LITTLE_ENDIAN), 0);
                boolean bootLoaderCommand = false;
                firmware = null;
                Node node = DaoUtils.getNodeDao().get(mySensorsRawMessage.getGatewayId(), mySensorsRawMessage.getNodeEui());
                if (node != null && node.getEraseConfig() != null && node.getEraseConfig().booleanValue()) {
                    bootLoaderCommand = true;
                    _logger.debug("Erase EEPROM has been set...");
                } else if (node != null && node.getFirmware() != null) {
                    firmware = (Firmware)DaoUtils.getFirmwareDao().getById(node.getFirmware().getId());
                    _logger.debug("Firmware selected based on node configuration...");
                } else if (firmwareConfigRequest.getType() == 65535 && firmwareConfigRequest.getVersion() == 65535) {
                    if (ObjectFactory.getAppProperties().getMySensorsSettings().getDefaultFirmware() != null) {
                        firmware = (Firmware)DaoUtils.getFirmwareDao().getById(ObjectFactory.getAppProperties().getMySensorsSettings().getDefaultFirmware());
                    } else {
                        _logger.warn("There is no default firmware set!");
                    }
                } else {
                    firmware = DaoUtils.getFirmwareDao().get(firmwareConfigRequest.getType(), firmwareConfigRequest.getVersion());
                }
                firmwareConfigResponse = new FirmwareConfigResponse();
                firmwareConfigResponse.setByteBufferPosition(0);
                if (bootLoaderCommand) {
                    if (node.getEraseConfig() != null && node.getEraseConfig().booleanValue()) {
                        firmwareConfigResponse.loadEraseEepromCommand();
                        node.setEraseConfig(false);
                        DaoUtils.getNodeDao().update(node);
                        break block20;
                    } else {
                        _logger.warn("Selected booloader command is not available, FirmwareConfigRequest:[{}]", (Object)firmwareConfigRequest);
                        return;
                    }
                }
                if (firmware == null) {
                    if (ObjectFactory.getAppProperties().getMySensorsSettings().getEnbaledDefaultOnNoFirmware().booleanValue()) {
                        _logger.debug("If requested firmware is not available, redirect to default firmware is set, Checking the default firmware");
                        if (ObjectFactory.getAppProperties().getMySensorsSettings().getDefaultFirmware() != null) {
                            firmware = (Firmware)DaoUtils.getFirmwareDao().getById(ObjectFactory.getAppProperties().getMySensorsSettings().getDefaultFirmware());
                            _logger.debug("Default firmware:[{}]", (Object)firmware.getFirmwareName());
                        } else {
                            _logger.warn("There is no default firmware set!");
                        }
                    }
                    if (firmware == null) {
                        _logger.warn("Selected Firmware is not available, FirmwareConfigRequest:[{}]", (Object)firmwareConfigRequest);
                        return;
                    }
                }
            }
            if (firmware != null) {
                firmwareConfigResponse.setType(firmware.getType().getId());
                firmwareConfigResponse.setVersion(firmware.getVersion().getId());
                firmwareConfigResponse.setBlocks(firmware.getBlocks());
                firmwareConfigResponse.setCrc(firmware.getCrc());
            }
            mySensorsRawMessage.setTxMessage(true);
            mySensorsRawMessage.setSubType(MYCMessages.MESSAGE_TYPE_STREAM.ST_FIRMWARE_CONFIG_RESPONSE.ordinal());
            mySensorsRawMessage.setPayload(Hex.encodeHexString((byte[])firmwareConfigResponse.getByteBuffer().array()).toUpperCase());
            ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
            _logger.debug("FirmwareConfigRequest:[{}]", (Object)firmwareConfigRequest);
            _logger.debug("FirmwareConfigResponse:[{}]", (Object)firmwareConfigResponse);
            return;
        }
        catch (DecoderException ex) {
            _logger.error("Exception, ", (Throwable)ex);
        }
    }

    private void responseReqTypeData(MySensorsRawMessage mySensorsRawMessage) {
        Sensor sensor = this.getSensor(mySensorsRawMessage);
        SensorVariable sensorVariable = DaoUtils.getSensorVariableDao().get(sensor.getId(), MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType()));
        if (sensorVariable != null && sensorVariable.getValue() != null) {
            if (ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.INFO)) {
                this.setSensorVariableData(ResourcesLogsUtils.LOG_LEVEL.INFO, MYCMessages.MESSAGE_TYPE.C_REQ, sensorVariable, mySensorsRawMessage, null);
            }
            mySensorsRawMessage.setTxMessage(true);
            mySensorsRawMessage.setMessageType(MYCMessages.MESSAGE_TYPE.C_SET.ordinal());
            mySensorsRawMessage.setAck(0);
            mySensorsRawMessage.setPayload(sensorVariable.getValue());
            ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
            _logger.debug("Request processed! Message Sent: {}", (Object)mySensorsRawMessage);
        } else {
            if (sensorVariable == null) {
                sensorVariable = this.updateSensorVariable(mySensorsRawMessage, this.getSensor(mySensorsRawMessage), MYCMessages.getPayLoadType(MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType())));
            }
            if (ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.WARNING)) {
                this.setSensorVariableData(ResourcesLogsUtils.LOG_LEVEL.WARNING, MYCMessages.MESSAGE_TYPE.C_REQ, sensorVariable, mySensorsRawMessage, "Data not available in MyController.org");
            }
            _logger.warn("Data not available! but there is request from sensor[{}], Ignored this request!", (Object)mySensorsRawMessage);
        }
    }

    private SensorVariable updateSensorVariable(MySensorsRawMessage mySensorsRawMessage, Sensor sensor, MYCMessages.PAYLOAD_TYPE payloadType) {
        SensorVariable sensorVariable = DaoUtils.getSensorVariableDao().get(sensor.getId(), MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType()));
        MetricsUtils.METRIC_TYPE metricType = MYCMessages.getMetricType(payloadType);
        if (sensorVariable == null) {
            sensorVariable = SensorVariable.builder().sensor(sensor).variableType(MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType())).value(mySensorsRawMessage.getPayload()).timestamp(System.currentTimeMillis()).metricType(metricType).build().updateUnitAndMetricType();
            _logger.debug("This SensorVariable:[{}] for Sensor:{}] is not available in our DB, Adding...", (Object)sensorVariable, (Object)sensor);
            DaoUtils.getSensorVariableDao().create(sensorVariable);
            sensorVariable = DaoUtils.getSensorVariableDao().get(sensorVariable);
        } else {
            sensorVariable.setValue(mySensorsRawMessage.getPayload());
            sensorVariable.setTimestamp(System.currentTimeMillis());
            DaoUtils.getSensorVariableDao().update(sensorVariable);
        }
        return sensorVariable;
    }

    private Sensor getSensor(MySensorsRawMessage mySensorsRawMessage) {
        Sensor sensor = DaoUtils.getSensorDao().get(mySensorsRawMessage.getGatewayId(), mySensorsRawMessage.getNodeEui(), mySensorsRawMessage.getChildSensorId());
        if (sensor == null) {
            this.getNode(mySensorsRawMessage);
            _logger.debug("This sensor[{} from Node:{}] not available in our DB, Adding...", (Object)mySensorsRawMessage.getChildSensorId(), (Object)mySensorsRawMessage.getNodeEui());
            sensor = Sensor.builder().sensorId(mySensorsRawMessage.getChildSensorId()).build();
            sensor.setNode(this.getNode(mySensorsRawMessage));
            DaoUtils.getSensorDao().create(sensor);
            sensor = DaoUtils.getSensorDao().get(mySensorsRawMessage.getGatewayId(), mySensorsRawMessage.getNodeEui(), mySensorsRawMessage.getChildSensorId());
        }
        return sensor;
    }

    private Node getNode(MySensorsRawMessage mySensorsRawMessage) {
        Node node = DaoUtils.getNodeDao().get(mySensorsRawMessage.getGatewayId(), mySensorsRawMessage.getNodeEui());
        if (node == null) {
            _logger.debug("This Node[{}] not available in our DB, Adding...", (Object)mySensorsRawMessage.getNodeEui());
            node = Node.builder().gateway(Gateway.builder().id(mySensorsRawMessage.getGatewayId()).build()).eui(mySensorsRawMessage.getNodeEui()).state(AppProperties.STATE.UP).build();
            node.setLastSeen(System.currentTimeMillis());
            DaoUtils.getNodeDao().create(node);
            node = DaoUtils.getNodeDao().get(mySensorsRawMessage.getGatewayId(), mySensorsRawMessage.getNodeEui());
        }
        _logger.debug("Node:[{}], message:[{}]", (Object)node, (Object)mySensorsRawMessage);
        return node;
    }

    private void updateNode(Node node) {
        node.setLastSeen(System.currentTimeMillis());
        DaoUtils.getNodeDao().update(node);
    }

    private void recordSetTypeData(MySensorsRawMessage mySensorsRawMessage) {
        List<AlarmDefinition> alarmDefinitions;
        List<ForwardPayload> forwardPayloads;
        MYCMessages.PAYLOAD_TYPE payloadType = MYCMessages.getPayLoadType(MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType()));
        Sensor sensor = this.getSensor(mySensorsRawMessage);
        if (!(MYCMessages.MESSAGE_TYPE_SET_REQ.V_RGB != MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType()) && MYCMessages.MESSAGE_TYPE_SET_REQ.V_RGBW != MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType()) || mySensorsRawMessage.getPayload().startsWith("#"))) {
            mySensorsRawMessage.setPayload("#" + mySensorsRawMessage.getPayload());
        }
        SensorVariable sensorVariable = this.updateSensorVariable(mySensorsRawMessage, sensor, payloadType);
        _logger.debug("Sensor:{}[NodeId:{},SesnorId:{},SubType({}):{}], PayLoad Type: {}", new Object[]{sensor.getName(), sensor.getNode().getEui(), sensor.getSensorId(), mySensorsRawMessage.getSubType(), MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType()), payloadType.toString()});
        if (mySensorsRawMessage.getSubType() == MYCMessages.MESSAGE_TYPE_SET_REQ.V_UNIT_PREFIX.ordinal()) {
            DaoUtils.getSensorDao().update(sensor);
            if (ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.NOTICE)) {
                this.setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL.NOTICE, mySensorsRawMessage, MYCMessages.MESSAGE_TYPE_SET_REQ.V_UNIT_PREFIX.getText(), null);
            }
            return;
        }
        sensor.setLastSeen(System.currentTimeMillis());
        DaoUtils.getSensorDao().update(sensor);
        switch (sensorVariable.getMetricType()) {
            case DOUBLE: {
                DaoUtils.getMetricsDoubleTypeDeviceDao().create(MetricsDoubleTypeDevice.builder().sensorVariable(sensorVariable).aggregationType(MetricsUtils.AGGREGATION_TYPE.RAW).timestamp(System.currentTimeMillis()).avg(NumericUtils.getDouble(mySensorsRawMessage.getPayload())).samples(1).build());
                break;
            }
            case BINARY: {
                DaoUtils.getMetricsBinaryTypeDeviceDao().create(MetricsBinaryTypeDevice.builder().sensorVariable(sensorVariable).timestamp(System.currentTimeMillis()).state(mySensorsRawMessage.getPayloadBoolean()).build());
                break;
            }
            default: {
                _logger.debug("This type not be implemented yet, PayloadType:{}, MessageType:{}, MySensorsRawMessage:{}", new Object[]{payloadType, MYCMessages.MESSAGE_TYPE_SET_REQ.get(mySensorsRawMessage.getSubType()).toString(), mySensorsRawMessage.getPayload()});
            }
        }
        if (ResourcesLogsUtils.isLevel(ResourcesLogsUtils.LOG_LEVEL.INFO)) {
            this.setSensorVariableData(ResourcesLogsUtils.LOG_LEVEL.INFO, MYCMessages.MESSAGE_TYPE.C_SET, sensorVariable, mySensorsRawMessage, null);
        }
        if (!mySensorsRawMessage.isTxMessage() && sensor.getType() != null && sensor.getType() != null && sensor.getType() == MYCMessages.MESSAGE_TYPE_PRESENTATION.S_CUSTOM && sensorVariable.getVariableType() == MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR5) {
            ExecuteUidTag executeUidTag = new ExecuteUidTag(sensor, sensorVariable);
            new Thread(executeUidTag).start();
        }
        if ((forwardPayloads = DaoUtils.getForwardPayloadDao().getAllEnabled(sensorVariable.getId())) != null && !forwardPayloads.isEmpty()) {
            ExecuteForwardPayload executeForwardPayload = new ExecuteForwardPayload(forwardPayloads, sensor, sensorVariable);
            new Thread(executeForwardPayload).run();
        }
        if ((alarmDefinitions = DaoUtils.getAlarmDefinitionDao().getAllEnabled(AppProperties.RESOURCE_TYPE.SENSOR_VARIABLE, sensorVariable.getId())).size() > 0 && alarmDefinitions != null) {
            AlarmEngine alarmEngine = new AlarmEngine(alarmDefinitions, sensorVariable);
            new Thread(alarmEngine).run();
        }
    }

    private void setSensorVariableData(ResourcesLogsUtils.LOG_LEVEL logLevel, MYCMessages.MESSAGE_TYPE type, SensorVariable sensorVariable, MySensorsRawMessage mySensorsRawMessage, String extraMessage) {
        this.setSensorOtherData(AppProperties.RESOURCE_TYPE.SENSOR_VARIABLE, sensorVariable.getId(), logLevel, type, null, mySensorsRawMessage.isTxMessage(), mySensorsRawMessage.getPayload(), extraMessage);
    }

    private void setSensorOtherData(ResourcesLogsUtils.LOG_LEVEL logLevel, MySensorsRawMessage mySensorsRawMessage, String messageSubType, String extraMessage) {
        if (mySensorsRawMessage.getChildSensorId() == 255) {
            Node node = DaoUtils.getNodeDao().get(mySensorsRawMessage.getGatewayId(), mySensorsRawMessage.getNodeEui());
            this.setSensorOtherData(AppProperties.RESOURCE_TYPE.NODE, node.getId(), logLevel, MYCMessages.MESSAGE_TYPE.get(mySensorsRawMessage.getMessageType()), messageSubType, mySensorsRawMessage.isTxMessage(), mySensorsRawMessage.getPayload(), extraMessage);
        } else {
            Sensor sensor = DaoUtils.getSensorDao().get(mySensorsRawMessage.getGatewayId(), mySensorsRawMessage.getNodeEui(), mySensorsRawMessage.getChildSensorId());
            if (sensor == null) {
                sensor = this.getSensor(mySensorsRawMessage);
            }
            this.setSensorOtherData(AppProperties.RESOURCE_TYPE.SENSOR, sensor.getId(), logLevel, MYCMessages.MESSAGE_TYPE.get(mySensorsRawMessage.getMessageType()), messageSubType, mySensorsRawMessage.isTxMessage(), mySensorsRawMessage.getPayload(), extraMessage);
        }
    }

    private void setSensorOtherData(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId, ResourcesLogsUtils.LOG_LEVEL logLevel, MYCMessages.MESSAGE_TYPE messageType, String subType, boolean isTxMessage, String payload, String extraMessage) {
        StringBuilder builder = new StringBuilder();
        if (subType != null) {
            builder.append("[").append(subType).append("]");
        }
        if (payload != null) {
            builder.append(" ").append(payload);
        }
        if (extraMessage != null) {
            builder.append(" ").append(extraMessage);
        }
        ResourcesLogsUtils.recordSensorsResourcesLog(resourceType, resourceId, logLevel, messageType, isTxMessage, builder.toString());
    }
}

