/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.metrics;

public class MetricsUtils {
    public static final long RAW_DATA_MAX_RETAIN_TIME = 60000L;
    public static final long ONE_MINUTE_MAX_RETAIN_TIME = 21600000L;
    public static final long FIVE_MINUTES_MAX_RETAIN_TIME = 604800000L;
    public static final long ONE_HOUR_MAX_RETAIN_TIME = 2592000000L;
    public static final long SIX_HOURS_MAX_RETAIN_TIME = 7776000000L;
    public static final long TWELVE_HOURS_MAX_RETAIN_TIME = 15552000000L;
    public static final long MILLISECONDS_2015 = 1420050600000L;

    private MetricsUtils() {
    }

    public static enum METRIC_TYPE {
        NONE("None"),
        DOUBLE("Double"),
        BINARY("Binary");

        private String text;

        public static METRIC_TYPE get(int id) {
            for (METRIC_TYPE metric_type : METRIC_TYPE.values()) {
                if (metric_type.ordinal() != id) continue;
                return metric_type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        public String getText() {
            return this.text;
        }

        private METRIC_TYPE(String text) {
            this.text = text;
        }

        public static METRIC_TYPE fromString(String text) {
            if (text != null) {
                for (METRIC_TYPE type : METRIC_TYPE.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum AGGREGATION_TYPE {
        RAW,
        ONE_MINUTE,
        FIVE_MINUTES,
        ONE_HOUR,
        SIX_HOURS,
        TWELVE_HOURS,
        ONE_DAY;


        public static AGGREGATION_TYPE get(int id) {
            for (AGGREGATION_TYPE type : AGGREGATION_TYPE.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }
    }
}

