/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.metrics;

import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.MetricsDoubleTypeDevice;
import org.mycontroller.standalone.metrics.MetricsUtils;

public class MetricsAggregationUtils {
    private MetricsAggregationUtils() {
    }

    public static void removePreviousData(MetricsUtils.AGGREGATION_TYPE type, long timestamp) {
        DaoUtils.getMetricsDoubleTypeDeviceDao().deletePrevious(MetricsDoubleTypeDevice.builder().aggregationType(type).timestamp(timestamp).build());
    }

    public static void purgeRawData() {
        MetricsAggregationUtils.purgeRawData(System.currentTimeMillis() - 60000L);
    }

    public static void purgeOneMinuteData() {
        MetricsAggregationUtils.purgeOneMinuteData(System.currentTimeMillis() - 21600000L);
    }

    public static void purgeFiveMinutesData() {
        MetricsAggregationUtils.purgeFiveMinutesData(System.currentTimeMillis() - 604800000L);
    }

    public static void purgeOneHourData() {
        MetricsAggregationUtils.purgeOneHourData(System.currentTimeMillis() - 2592000000L);
    }

    public static void purgeRawData(long timestamp) {
        MetricsAggregationUtils.removePreviousData(MetricsUtils.AGGREGATION_TYPE.RAW, timestamp);
    }

    public static void purgeOneMinuteData(long timestamp) {
        MetricsAggregationUtils.removePreviousData(MetricsUtils.AGGREGATION_TYPE.ONE_MINUTE, timestamp);
    }

    public static void purgeFiveMinutesData(long timestamp) {
        MetricsAggregationUtils.removePreviousData(MetricsUtils.AGGREGATION_TYPE.FIVE_MINUTES, timestamp);
    }

    public static void purgeOneHourData(long timestamp) {
        MetricsAggregationUtils.removePreviousData(MetricsUtils.AGGREGATION_TYPE.ONE_HOUR, timestamp);
    }
}

