/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.message;

import java.util.ArrayList;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMessageQueue {
    private static Logger _logger = LoggerFactory.getLogger((String)RawMessageQueue.class.getName());
    private ArrayList<RawMessage> rawMessages = new ArrayList();
    private int queueSize;

    public RawMessageQueue() {
        this.queueSize = 1000;
        _logger.debug("Defined Queue Size:{}", (Object)this.queueSize);
    }

    public RawMessageQueue(int queueSize) {
        this.queueSize = queueSize;
        _logger.debug("Defined Queue Size:{}", (Object)queueSize);
    }

    public synchronized void putMessage(RawMessage rawMessage) {
        if (this.rawMessages.size() < this.queueSize) {
            this.rawMessages.add(rawMessage);
            _logger.debug("Added new message, Queue size:{}, Message:[{}]", (Object)this.rawMessages.size(), (Object)rawMessage);
        } else {
            _logger.warn("Reached Maximun limit: {}, Unable to add new message. Dropped", (Object)this.rawMessages.size());
        }
    }

    public synchronized RawMessage getMessage() {
        if (this.rawMessages.size() > 0) {
            RawMessage rawMessage = this.rawMessages.get(0);
            this.rawMessages.remove(0);
            _logger.debug("Removed a message, Queue size:{}, Message:[{}]", (Object)this.rawMessages.size(), (Object)rawMessage);
            return rawMessage;
        }
        _logger.warn("There are no messages in the queue, returning null");
        return null;
    }

    public synchronized int getQueueSize() {
        return this.rawMessages.size();
    }

    public synchronized boolean isEmpty() {
        return this.rawMessages.isEmpty();
    }
}

