/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.serialport;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDataListenerjSerialComm
implements SerialPortDataListener {
    private static final Logger _logger = LoggerFactory.getLogger((String)SerialDataListenerjSerialComm.class.getName());
    private SerialPort serialPort;
    private GatewaySerial gateway = null;
    private StringBuilder message = new StringBuilder();
    private boolean failedStatusWritten = false;

    public SerialDataListenerjSerialComm(SerialPort serialPort, GatewaySerial gateway) {
        this.serialPort = serialPort;
        this.gateway = gateway;
    }

    public int getListeningEvents() {
        return 1;
    }

    public void serialEvent(SerialPortEvent event) {
        if (event.getEventType() != 1) {
            return;
        }
        try {
            byte[] buffer = new byte[this.serialPort.bytesAvailable()];
            this.serialPort.readBytes(buffer, (long)buffer.length);
            for (byte b : buffer) {
                if (b == 10 && this.message.length() > 0) {
                    String toProcess = this.message.toString();
                    _logger.debug("Received a message:[{}]", (Object)toProcess);
                    ObjectFactory.getRawMessageQueue().putMessage(new RawMessage(this.gateway.getId(), toProcess));
                    this.message.setLength(0);
                    continue;
                }
                if (b != 10) {
                    _logger.trace("Received a char:[{}]", (Object)Character.valueOf((char)b));
                    this.message.append((char)b);
                    continue;
                }
                if (this.message.length() >= 1000) {
                    _logger.warn("Serial receive buffer size reached to MAX level[{} chars], Now clearing the buffer. Existing data:[{}]", (Object)1000, (Object)this.message.toString());
                    this.message.setLength(0);
                    continue;
                }
                _logger.debug("Received MESSAGE_SPLITTER and current message length is ZERO! Nothing to do");
            }
            this.failedStatusWritten = false;
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                _logger.error("Exception, ", (Throwable)ex);
            }
            if (!this.failedStatusWritten) {
                this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
                this.gateway.updateGateway();
                this.failedStatusWritten = true;
                _logger.error("Exception, ", (Throwable)ex);
            }
            this.message.setLength(0);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException tE) {
                _logger.error("Exception,", (Throwable)tE);
            }
        }
    }
}

