/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway;

import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.PayloadOperation;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.gateway.GatewayEthernet;
import org.mycontroller.standalone.gateway.GatewayMQTT;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.gateway.ethernet.EthernetGatewayImpl;
import org.mycontroller.standalone.gateway.mqtt.MqttGatewayImpl;
import org.mycontroller.standalone.gateway.serialport.MYCSerialPort;
import org.mycontroller.standalone.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayUtils {
    private static final Logger _logger = LoggerFactory.getLogger((String)GatewayUtils.class.getName());
    public static final String OS_ARCH_ARM = "arm";

    private GatewayUtils() {
    }

    public static synchronized void loadGateway(Gateway gateway) {
        if (!gateway.getEnabled().booleanValue()) {
            return;
        }
        IGateway iGateway = null;
        switch (gateway.getType()) {
            case SERIAL: {
                iGateway = new MYCSerialPort(gateway);
                break;
            }
            case ETHERNET: {
                iGateway = new EthernetGatewayImpl(gateway);
                break;
            }
            case MQTT: {
                iGateway = new MqttGatewayImpl(gateway);
                break;
            }
            default: {
                _logger.warn("Not implemented yet! Gateway:[{}]", (Object)gateway.getType().getText());
            }
        }
        if (iGateway == null) {
            throw new RuntimeException("Unable to create gateway[" + gateway + "]...Check your input");
        }
        ObjectFactory.addGateway(iGateway);
    }

    public static synchronized void unloadGateway(Integer gatewayId) {
        if (ObjectFactory.getGateway(gatewayId) != null) {
            ObjectFactory.getGateway(gatewayId).close();
            ObjectFactory.removeGateway(gatewayId);
        }
    }

    public static synchronized void loadAllGateways() {
        List<Gateway> gateways = DaoUtils.getGatewayDao().getAllEnabled();
        for (Gateway gateway : gateways) {
            GatewayUtils.loadGateway(gateway);
        }
    }

    public static synchronized void unloadAllGateways() {
        for (Integer gatewayId : ObjectFactory.getGatewayIds()) {
            GatewayUtils.unloadGateway(gatewayId);
        }
    }

    public static synchronized void reloadGateways() {
        GatewayUtils.unloadAllGateways();
        GatewayUtils.loadAllGateways();
    }

    public static void reloadGateway(Integer gatewayId) {
        GatewayUtils.unloadGateway(gatewayId);
        Gateway gateway = (Gateway)DaoUtils.getGatewayDao().getById(gatewayId);
        GatewayUtils.loadGateway(gateway);
    }

    public static void reloadGateways(List<Integer> ids) {
        for (Integer id : ids) {
            GatewayUtils.reloadGateway(id);
        }
    }

    public static void updateGateway(Gateway gateway) {
        GatewayUtils.unloadGateway(gateway.getId());
        DaoUtils.getGatewayDao().update(gateway);
        if (gateway.getEnabled().booleanValue()) {
            GatewayUtils.loadGateway(gateway);
        }
    }

    public static void addGateway(Gateway gateway) {
        DaoUtils.getGatewayDao().create(gateway);
        gateway.setTimestamp(System.currentTimeMillis());
        if (gateway.getEnabled().booleanValue()) {
            gateway.setEnabled(true);
            GatewayUtils.loadGateway(gateway);
        }
    }

    public static void enableGateway(Integer gatewayId) {
        GatewayUtils.unloadGateway(gatewayId);
        Gateway gateway = (Gateway)DaoUtils.getGatewayDao().getById(gatewayId);
        gateway.setEnabled(true);
        GatewayUtils.loadGateway(gateway);
        DaoUtils.getGatewayDao().update(gateway);
    }

    public static void disableGateway(Integer gatewayId) {
        GatewayUtils.unloadGateway(gatewayId);
        Gateway gateway = (Gateway)DaoUtils.getGatewayDao().getById(gatewayId);
        gateway.setEnabled(false);
        gateway.setState(AppProperties.STATE.UNAVAILABLE);
        gateway.setStatusMessage("Disabled by user");
        DaoUtils.getGatewayDao().update(gateway);
    }

    public static void enableGateways(List<Integer> ids) {
        for (Integer id : ids) {
            GatewayUtils.enableGateway(id);
        }
    }

    public static void disableGateways(List<Integer> ids) {
        for (Integer id : ids) {
            GatewayUtils.disableGateway(id);
        }
    }

    public static String getConnectionDetails(Gateway gateway) {
        if (gateway.getType() == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        switch (gateway.getType()) {
            case SERIAL: {
                GatewaySerial gatewaySerial = new GatewaySerial(gateway);
                builder.append("Port:").append(gatewaySerial.getPortName());
                builder.append(", BaudRate:").append(gatewaySerial.getBaudRate());
                builder.append(", Driver:").append(gatewaySerial.getDriver().getText());
                if (gatewaySerial.getDriver() == SERIAL_PORT_DRIVER.AUTO && gatewaySerial.getRunningDriver() != null) {
                    builder.append("[").append(gatewaySerial.getRunningDriver().getText()).append("]");
                }
                builder.append(", RetryFrequency:").append(gatewaySerial.getRetryFrequency()).append(" Second(s)");
                break;
            }
            case ETHERNET: {
                GatewayEthernet gatewayEthernet = new GatewayEthernet(gateway);
                builder.append("Host:").append(gatewayEthernet.getHost());
                builder.append(", Port:").append(gatewayEthernet.getPort());
                break;
            }
            case MQTT: {
                GatewayMQTT gatewayMqtt = new GatewayMQTT(gateway);
                builder.append("BrokerHost:").append(gatewayMqtt.getBrokerHost());
                builder.append(", ClientId:").append(gatewayMqtt.getClientId());
                break;
            }
        }
        return builder.toString();
    }

    public static void executeGatewayOperation(ResourceModel resourceModel, PayloadOperation operation) {
        switch (operation.getOperationType()) {
            case ENABLE: {
                GatewayUtils.enableGateway(resourceModel.getResourceId());
                break;
            }
            case DISABLE: {
                GatewayUtils.disableGateway(resourceModel.getResourceId());
                break;
            }
            case RELOAD: {
                GatewayUtils.reloadGateway(resourceModel.getResourceId());
                break;
            }
            default: {
                _logger.warn("Gateway will not support for this operation!:[{}]", (Object)operation.getOperationType().getText());
            }
        }
    }

    public static enum SERIAL_PORT_DRIVER {
        AUTO("Auto"),
        PI4J("pi4j"),
        JSSC("jssc"),
        JSERIALCOMM("jSerialComm");

        private final String name;

        private SERIAL_PORT_DRIVER(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public static SERIAL_PORT_DRIVER get(int id) {
            for (SERIAL_PORT_DRIVER type : SERIAL_PORT_DRIVER.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        public static SERIAL_PORT_DRIVER fromString(String text) {
            if (text != null) {
                for (SERIAL_PORT_DRIVER type : SERIAL_PORT_DRIVER.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum TYPE {
        SERIAL("Serial"),
        ETHERNET("Ethernet"),
        MQTT("MQTT");

        private String value;

        public static TYPE get(int id) {
            for (TYPE type : TYPE.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        private TYPE(String value) {
            this.value = value;
        }

        public String getText() {
            return this.value;
        }

        public static TYPE fromString(String text) {
            if (text != null) {
                for (TYPE type : TYPE.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

