/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.SettingsDao;
import org.mycontroller.standalone.db.tables.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsDaoImpl
extends BaseAbstractDaoImpl<Settings, Integer>
implements SettingsDao {
    private static final Logger _logger = LoggerFactory.getLogger(SettingsDaoImpl.class);

    public SettingsDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, Settings.class);
    }

    @Override
    public Settings get(Settings settings) {
        return (Settings)this.getById(settings.getId());
    }

    @Override
    public List<Settings> getAll(List<Integer> ids) {
        return this.getAll("id", ids);
    }

    @Override
    public Settings get(String key, String subKey) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("key", (Object)key).and().eq("subKey", (Object)subKey);
            return (Settings)queryBuilder.queryForFirst();
        }
        catch (SQLException ex) {
            _logger.error("unable to get item for key:{}, subKey:{}", new Object[]{key, subKey, ex});
            return null;
        }
    }

    @Override
    public void update(String key, String subKey, String value, String altValue) {
        try {
            this.createIfNotAvailable(key, subKey);
            UpdateBuilder updateBuilder = this.getDao().updateBuilder();
            updateBuilder.where().eq("key", (Object)key).and().eq("subKey", (Object)subKey);
            updateBuilder.updateColumnValue("value", (Object)value);
            updateBuilder.updateColumnValue("altValue", (Object)altValue);
            int count = updateBuilder.update();
            _logger.debug("update count:{}", (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to get item for key:{}, subKey:{}", new Object[]{key, subKey, ex});
        }
    }

    @Override
    public void update(String key, String subKey, String value) {
        try {
            this.createIfNotAvailable(key, subKey);
            UpdateBuilder updateBuilder = this.getDao().updateBuilder();
            updateBuilder.where().eq("key", (Object)key).and().eq("subKey", (Object)subKey);
            updateBuilder.updateColumnValue("value", (Object)value);
            int count = updateBuilder.update();
            _logger.debug("update count:{}", (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to get item for key:{}, subKey:{}", new Object[]{key, subKey, ex});
        }
    }

    private void createIfNotAvailable(String key, String subKey) {
        if (this.get(key, subKey) == null) {
            this.create(Settings.builder().key(key).subKey(subKey).build());
        }
    }
}

