/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db;

import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.db.tables.ResourcesGroup;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.db.tables.Timer;
import org.mycontroller.standalone.gateway.GatewayUtils;
import org.mycontroller.standalone.scheduler.SchedulerUtils;
import org.mycontroller.standalone.timer.TimerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteResourceUtils {
    private static final Logger _logger = LoggerFactory.getLogger((String)DeleteResourceUtils.class.getName());

    private DeleteResourceUtils() {
    }

    public static void deleteSensor(Integer sensorId) {
        DeleteResourceUtils.deleteSensor((Sensor)DaoUtils.getSensorDao().getById(sensorId));
    }

    public static void deleteSensor(Sensor sensor) {
        List<Timer> timers = DaoUtils.getTimerDao().getAll(AppProperties.RESOURCE_TYPE.SENSOR, sensor.getId());
        SchedulerUtils.unloadTimerJobs(timers);
        DaoUtils.getTimerDao().delete(AppProperties.RESOURCE_TYPE.SENSOR, sensor.getId());
        DaoUtils.getAlarmDefinitionDao().delete(AppProperties.RESOURCE_TYPE.SENSOR, sensor.getId());
        List<SensorVariable> sensorVariables = DaoUtils.getSensorVariableDao().getAll(sensor.getId());
        for (SensorVariable sensorVariable : sensorVariables) {
            DeleteResourceUtils.deleteSensorValue(sensorVariable);
        }
        DaoUtils.getForwardPayloadDao().deleteBySensorId(sensor.getId());
        DaoUtils.getResourcesLogsDao().deleteAll(AppProperties.RESOURCE_TYPE.SENSOR, sensor.getId());
        DaoUtils.getUidTagDao().deleteBySensorRefId(sensor.getId());
        DaoUtils.getSensorDao().delete(sensor);
        _logger.debug("Deleted sensor trace for sensor:[{}]", (Object)sensor);
    }

    public static void deleteSensorValue(SensorVariable sensorVariable) {
        DaoUtils.getMetricsDoubleTypeDeviceDao().deleteBySensorVariableRefId(sensorVariable.getId());
        DaoUtils.getMetricsBinaryTypeDeviceDao().deleteBySensorValueRefId(sensorVariable.getId());
        DaoUtils.getSensorVariableDao().delete(sensorVariable);
    }

    public static void deleteNode(Node node) {
        List<Sensor> sensors = DaoUtils.getSensorDao().getAll(node.getId());
        for (Sensor sensor : sensors) {
            DeleteResourceUtils.deleteSensor(sensor);
        }
        DaoUtils.getNodeDao().delete(node.getId());
        _logger.debug("Deleted node trace for node:[{}]", (Object)node);
    }

    public static void deleteNodes(List<Integer> nodeIds) {
        List<Sensor> sensors = DaoUtils.getSensorDao().getAllByNodeIds(nodeIds);
        for (Sensor sensor : sensors) {
            DeleteResourceUtils.deleteSensor(sensor);
        }
        DaoUtils.getNodeDao().delete(nodeIds);
        _logger.debug("Deleted node trace for nodeIds:[{}]", nodeIds);
    }

    public static void deleteSensors(List<Integer> sensorIds) {
        List<Sensor> sensors = DaoUtils.getSensorDao().getAllByIds(sensorIds);
        for (Sensor sensor : sensors) {
            DeleteResourceUtils.deleteSensor(sensor);
        }
    }

    public static void deleteGateway(Integer id) {
        GatewayUtils.unloadGateway(id);
        List<Node> nodes = DaoUtils.getNodeDao().getAll(id);
        for (Node node : nodes) {
            DeleteResourceUtils.deleteNode(node);
        }
        DaoUtils.getGatewayDao().deleteById(id);
    }

    public static void deleteGateways(List<Integer> ids) {
        for (Integer id : ids) {
            DeleteResourceUtils.deleteGateway(id);
        }
    }

    public static void deleteAlarmDefinitions(List<Integer> ids) {
        for (Integer id : ids) {
            DeleteResourceUtils.deleteAlarmDefinition(id);
        }
    }

    public static synchronized void deleteAlarmDefinition(AlarmDefinition alarmDefinition) {
        Timer timer = new Timer();
        timer.setName(AlarmUtils.getAlarmTimerJobName(alarmDefinition));
        SchedulerUtils.unloadTimerJob(timer);
        DaoUtils.getAlarmDefinitionDao().deleteById(alarmDefinition.getId());
    }

    public static synchronized void deleteAlarmDefinition(Integer id) {
        DeleteResourceUtils.deleteAlarmDefinition((AlarmDefinition)DaoUtils.getAlarmDefinitionDao().getById(id));
    }

    public static synchronized void deleteTimer(Timer timer) {
        SchedulerUtils.unloadTimerJob(timer);
        DaoUtils.getTimerDao().delete(timer.getId());
    }

    public static synchronized void deleteTimer(Integer id) {
        DeleteResourceUtils.deleteTimer(DaoUtils.getTimerDao().get(id));
    }

    public static synchronized void deleteResourcesGroup(List<Integer> ids) {
        for (Integer id : ids) {
            DeleteResourceUtils.deleteResourcesGroup(id);
        }
    }

    public static synchronized void deleteResourcesGroup(Integer id) {
        ResourcesGroup resourcesGroup = DaoUtils.getResourcesGroupDao().get(id);
        List<Timer> timers = DaoUtils.getTimerDao().getAll(AppProperties.RESOURCE_TYPE.RESOURCES_GROUP, resourcesGroup.getId());
        for (Timer timer : timers) {
            TimerUtils.deleteTimer(timer);
        }
        List<AlarmDefinition> alarmDefinitions = DaoUtils.getAlarmDefinitionDao().getAll(AppProperties.RESOURCE_TYPE.RESOURCES_GROUP, resourcesGroup.getId());
        for (AlarmDefinition alarmDefinition : alarmDefinitions) {
            DeleteResourceUtils.deleteAlarmDefinition(alarmDefinition);
        }
        DaoUtils.getResourcesGroupMapDao().delete(ResourcesGroup.builder().id(id).build());
        DaoUtils.getResourcesGroupDao().delete(id);
    }
}

