/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class NumericUtils {
    public static final int DOUBLE_ROUND = 3;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final DecimalFormat decimalFormat = new DecimalFormat("#.###");

    private NumericUtils() {
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static Double getDouble(String value) {
        return NumericUtils.round(Double.valueOf(value), 3);
    }

    public static String getDoubleAsString(double value) {
        Double truncatedDouble = new BigDecimal(value).setScale(3, 4).doubleValue();
        return String.valueOf(truncatedDouble);
    }

    public static String getDoubleAsString(String value) {
        if (value != null) {
            return NumericUtils.getDoubleAsString(Double.valueOf(value));
        }
        return "-";
    }

    public static Integer getInteger(String value) {
        if (value != null) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public static Long getLong(String value) {
        if (value != null) {
            return Long.valueOf(value);
        }
        return null;
    }

    public static Boolean getBoolean(String value) {
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static String getStatusAsString(String value) {
        if (value != null) {
            return value.equalsIgnoreCase("0") ? "OFF" : "ON";
        }
        return "-";
    }

    public static String getArmedAsString(String value) {
        if (value != null) {
            return value.equalsIgnoreCase("0") ? "Bypassed" : "Armed";
        }
        return "-";
    }

    public static String getTrippedAsString(String value) {
        if (value != null) {
            return value.equalsIgnoreCase("0") ? "Untripped" : "Tripped";
        }
        return "-";
    }

    public static String getLockStatusAsString(String value) {
        if (value != null) {
            return value.equalsIgnoreCase("0") ? "Unlocked" : "Locked";
        }
        return "-";
    }

    public static String getDifferenceFriendlyTime(long timestamp) {
        long diffMills = System.currentTimeMillis() - timestamp;
        String friendlyTime = NumericUtils.getFriendlyTime(diffMills, false);
        if (friendlyTime.contains("Now")) {
            return friendlyTime;
        }
        return friendlyTime + " ago";
    }

    private static void updateFriendlyTime(StringBuilder builder, long milliseconds) {
        long diffMills = milliseconds;
        long diffSeconds = diffMills / 1000L;
        long diffMinutes = diffMills / 60000L;
        long diffHours = diffMills / 3600000L;
        long diffDays = diffMills / 86400000L;
        if (milliseconds >= 1000L) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            if (diffDays > 0L) {
                builder.append(diffDays);
                if (diffDays == 1L) {
                    builder.append(" Day");
                } else {
                    builder.append(" Days");
                }
            } else if (diffHours > 0L) {
                builder.append(diffHours);
                if (diffHours == 1L) {
                    builder.append(" Hour");
                } else {
                    builder.append(" Hours");
                }
            } else if (diffMinutes > 0L) {
                builder.append(diffMinutes);
                if (diffMinutes == 1L) {
                    builder.append(" Minute");
                } else {
                    builder.append(" Minutes");
                }
            } else if (diffSeconds > 0L) {
                builder.append(diffSeconds);
                if (diffSeconds == 1L) {
                    builder.append(" Second");
                } else {
                    builder.append(" Seconds");
                }
            }
        }
    }

    public static String getFriendlyTime(Long milliseconds, boolean strict) {
        if (milliseconds == null) {
            return "-";
        }
        StringBuilder builder = new StringBuilder();
        if (strict) {
            while (milliseconds >= 1000L) {
                if (milliseconds >= 86400000L) {
                    NumericUtils.updateFriendlyTime(builder, milliseconds);
                    milliseconds = milliseconds % 86400000L;
                    continue;
                }
                if (milliseconds >= 3600000L) {
                    NumericUtils.updateFriendlyTime(builder, milliseconds);
                    milliseconds = milliseconds % 3600000L;
                    continue;
                }
                if (milliseconds >= 60000L) {
                    NumericUtils.updateFriendlyTime(builder, milliseconds);
                    milliseconds = milliseconds % 60000L;
                    continue;
                }
                if (milliseconds >= 1000L) {
                    NumericUtils.updateFriendlyTime(builder, milliseconds);
                    milliseconds = milliseconds % 1000L;
                    continue;
                }
                break;
            }
        } else {
            NumericUtils.updateFriendlyTime(builder, milliseconds);
        }
        if (builder.length() == 0) {
            builder.append("Now");
        }
        return builder.toString();
    }
}

