/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.timer;

import com.luckycatlabs.sunrisesunset.SunriseSunsetCalculator;
import com.luckycatlabs.sunrisesunset.dto.Location;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.DeleteResourceUtils;
import org.mycontroller.standalone.db.tables.Timer;
import org.mycontroller.standalone.jobs.ManageSunRiseSetJobs;
import org.mycontroller.standalone.scheduler.SchedulerUtils;
import org.mycontroller.standalone.settings.LocationSettings;
import org.mycontroller.standalone.timer.TimerSimple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerUtils {
    private static final Logger _logger = LoggerFactory.getLogger(TimerUtils.class);
    public static Date sunriseTime;
    public static Date sunsetTime;

    private TimerUtils() {
    }

    public static void updateSunriseSunset() throws Exception {
        Date tmpSunriseTime = sunriseTime;
        LocationSettings locationSettings = LocationSettings.get();
        Location location = new Location(locationSettings.getLatitude(), locationSettings.getLongitude());
        SunriseSunsetCalculator sunriseSunsetCalculator = new SunriseSunsetCalculator(location, TimeZone.getDefault());
        sunriseTime = sunriseSunsetCalculator.getOfficialSunriseCalendarForDate(Calendar.getInstance()).getTime();
        sunsetTime = sunriseSunsetCalculator.getOfficialSunsetCalendarForDate(Calendar.getInstance()).getTime();
        LocationSettings.builder().sunriseTime(sunriseTime.getTime()).sunsetTime(sunsetTime.getTime()).build().updateInternal();
        if (tmpSunriseTime != null && sunriseTime != null && tmpSunriseTime.getTime() != sunriseTime.getTime()) {
            new Thread(new ManageSunRiseSetJobs()).start();
        }
    }

    public static Date getSunriseTime() {
        return sunriseTime;
    }

    public static Date getSunsetTime() {
        return sunsetTime;
    }

    public static String getFrequencyData(Timer timer) {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(timer.getFrequencyType().getText()).append("-->");
        switch (timer.getFrequencyType()) {
            case DAILY: 
            case WEEKLY: {
                String[] days;
                for (String day : days = timer.getFrequencyData().split(",")) {
                    builder.append(WEEK_DAY.fromString(day).getText()).append(",");
                }
                builder.delete(builder.lastIndexOf(","), builder.lastIndexOf(",") + 1);
                break;
            }
            case MONTHLY: {
                builder.append(timer.getFrequencyData());
                break;
            }
        }
        builder.append("], [Time: ").append(new SimpleDateFormat(ObjectFactory.getAppProperties().getTimeFormat()).format(new Date(timer.getTriggerTime()))).append("]");
        return builder.toString();
    }

    public static String getTimerDataString(Timer timer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(timer.getTimerType().getText());
        stringBuilder.append(", ");
        switch (timer.getTimerType()) {
            case CRON: {
                stringBuilder.append("[").append(timer.getFrequencyData()).append("]");
                break;
            }
            case SIMPLE: {
                TimerSimple timerSimple = new TimerSimple(timer);
                stringBuilder.append("Repeat[Interval:").append(NumericUtils.getFriendlyTime(timerSimple.getRepeatInterval(), true)).append(", Count:").append(timerSimple.getRepeatCount()).append("], ").append("Executed count:").append(timerSimple.getExecutedCount());
                break;
            }
            case NORMAL: 
            case BEFORE_SUNRISE: 
            case AFTER_SUNRISE: 
            case BEFORE_SUNSET: 
            case AFTER_SUNSET: {
                stringBuilder.append(TimerUtils.getFrequencyData(timer));
                break;
            }
        }
        return stringBuilder.toString();
    }

    public static String getValidityString(Timer timer) {
        StringBuilder stringBuilder = new StringBuilder();
        if (timer.getValidityFrom() != null && timer.getValidityTo() != null) {
            stringBuilder.append(new SimpleDateFormat(ObjectFactory.getAppProperties().getDateFormatWithoutSeconds()).format(new Date(timer.getValidityFrom())));
            stringBuilder.append(" ~ ");
            stringBuilder.append(new SimpleDateFormat(ObjectFactory.getAppProperties().getDateFormatWithoutSeconds()).format(new Date(timer.getValidityTo())));
        } else if (timer.getValidityFrom() != null) {
            stringBuilder.append("From ");
            stringBuilder.append(new SimpleDateFormat(ObjectFactory.getAppProperties().getDateFormatWithoutSeconds()).format(new Date(timer.getValidityFrom())));
        } else if (timer.getValidityTo() != null) {
            stringBuilder.append("Till ");
            stringBuilder.append(new SimpleDateFormat(ObjectFactory.getAppProperties().getDateFormatWithoutSeconds()).format(new Date(timer.getValidityTo())));
        }
        return stringBuilder.toString();
    }

    public static Long getValidFromToTime(String date) {
        try {
            return new SimpleDateFormat(ObjectFactory.getAppProperties().getDateFormat()).parse(date).getTime();
        }
        catch (ParseException ex) {
            _logger.error("exception, ", (Throwable)ex);
            return null;
        }
    }

    public static Long getTime(String time) {
        try {
            return new SimpleDateFormat("HH:mm:ss").parse(time).getTime();
        }
        catch (ParseException ex) {
            _logger.error("exception, ", (Throwable)ex);
            return null;
        }
    }

    public static synchronized void updateTimer(Timer timer) {
        Timer timerOld = DaoUtils.getTimerDao().get(timer.getId());
        SchedulerUtils.unloadTimerJob(timerOld);
        timer.setLastFired(null);
        if (timer.getEnabled().booleanValue()) {
            timer.setInternalVariable1(null);
        }
        DaoUtils.getTimerDao().update(timer);
        SchedulerUtils.loadTimerJob(timer);
    }

    public static synchronized void addTimer(Timer timer) {
        DaoUtils.getTimerDao().create(timer);
        timer.setLastFired(null);
        if (timer.getEnabled().booleanValue()) {
            timer.setInternalVariable1(null);
            SchedulerUtils.loadTimerJob(timer);
        }
    }

    public static synchronized void enableTimer(Timer timer) {
        if (timer.getEnabled().booleanValue()) {
            _logger.debug("Timer already in enabled state, nothing to do, [{}]", (Object)timer);
            return;
        }
        timer.setInternalVariable1(null);
        timer.setEnabled(true);
        DaoUtils.getTimerDao().update(timer);
        SchedulerUtils.loadTimerJob(timer);
    }

    public static synchronized void disableTimer(Timer timer) {
        if (!timer.getEnabled().booleanValue()) {
            _logger.debug("Timer already in disabled state, nothing to do, [{}]", (Object)timer);
            return;
        }
        SchedulerUtils.unloadTimerJob(timer);
        timer.setEnabled(false);
        DaoUtils.getTimerDao().update(timer);
    }

    public static synchronized void deleteTimer(Integer id) {
        DeleteResourceUtils.deleteTimer(id);
    }

    public static synchronized void deleteTimer(Timer timer) {
        DeleteResourceUtils.deleteTimer(timer);
    }

    public static synchronized void enableTimers(List<Integer> ids) {
        for (Integer id : ids) {
            Timer timer = DaoUtils.getTimerDao().get(id);
            TimerUtils.enableTimer(timer);
        }
    }

    public static synchronized void disableTimers(List<Integer> ids) {
        for (Integer id : ids) {
            Timer timer = DaoUtils.getTimerDao().get(id);
            TimerUtils.disableTimer(timer);
        }
    }

    public static synchronized void deleteTimers(List<Integer> ids) {
        for (Integer id : ids) {
            TimerUtils.deleteTimer(id);
        }
    }

    public static enum WEEK_DAY {
        MONDAY("MON"),
        TUESDAY("TUE"),
        WEDNESDAY("WED"),
        THURSDAY("THU"),
        FRIDAY("FRI"),
        SATURDAY("SAT"),
        SUNDAY("SUN");

        private String value;

        public static WEEK_DAY get(int id) {
            for (WEEK_DAY weekday : WEEK_DAY.values()) {
                if (weekday.ordinal() != id) continue;
                return weekday;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        private WEEK_DAY(String value) {
            this.value = value;
        }

        public String getText() {
            return this.value;
        }

        public static WEEK_DAY fromString(String text) {
            if (text != null) {
                for (WEEK_DAY type : WEEK_DAY.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum FREQUENCY_TYPE {
        DAILY("Daily"),
        WEEKLY("Weekly"),
        MONTHLY("Monthly");

        private String value;

        public static FREQUENCY_TYPE get(int id) {
            for (FREQUENCY_TYPE frequency_type : FREQUENCY_TYPE.values()) {
                if (frequency_type.ordinal() != id) continue;
                return frequency_type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        private FREQUENCY_TYPE(String value) {
            this.value = value;
        }

        public String getText() {
            return this.value;
        }

        public static FREQUENCY_TYPE fromString(String text) {
            if (text != null) {
                for (FREQUENCY_TYPE type : FREQUENCY_TYPE.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum TIMER_TYPE {
        SIMPLE("Simple"),
        NORMAL("Normal"),
        CRON("Cron"),
        BEFORE_SUNRISE("Before sunrise"),
        AFTER_SUNRISE("After sunrise"),
        BEFORE_SUNSET("Before sunset"),
        AFTER_SUNSET("After sunset");

        private String value;

        public static TIMER_TYPE get(int id) {
            for (TIMER_TYPE timer_type : TIMER_TYPE.values()) {
                if (timer_type.ordinal() != id) continue;
                return timer_type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        private TIMER_TYPE(String value) {
            this.value = value;
        }

        public String getText() {
            return this.value;
        }

        public static TIMER_TYPE fromString(String text) {
            if (text != null) {
                for (TIMER_TYPE type : TIMER_TYPE.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

