/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.model;

import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.db.DaoUtils;

public class ResourceCountModel {
    private Long nodes;
    private Long sensors;
    private Long timers;
    private Long alarmDefinitions;
    private Long resourcesGroups;
    private AppProperties.RESOURCE_TYPE resourceType;
    private Integer resourceId;

    public ResourceCountModel(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        switch (resourceType) {
            case GATEWAY: {
                this.nodes = DaoUtils.getNodeDao().countOf(resourceId);
                this.alarmDefinitions = DaoUtils.getAlarmDefinitionDao().countOf(resourceType, resourceId);
                this.timers = DaoUtils.getTimerDao().countOf(resourceType, resourceId);
                this.resourcesGroups = DaoUtils.getResourcesGroupMapDao().countOf(resourceType, resourceId);
                break;
            }
            case NODE: {
                this.sensors = DaoUtils.getSensorDao().countOf(resourceId);
                this.alarmDefinitions = DaoUtils.getAlarmDefinitionDao().countOf(resourceType, resourceId);
                this.timers = DaoUtils.getTimerDao().countOf(resourceType, resourceId);
                this.resourcesGroups = DaoUtils.getResourcesGroupMapDao().countOf(resourceType, resourceId);
                break;
            }
            case SENSOR: {
                List<Integer> ids = DaoUtils.getSensorVariableDao().getSensorVariableIds(resourceId);
                this.alarmDefinitions = DaoUtils.getAlarmDefinitionDao().countOf(AppProperties.RESOURCE_TYPE.SENSOR_VARIABLE, ids);
                this.timers = DaoUtils.getTimerDao().countOf(resourceType, resourceId);
                this.resourcesGroups = DaoUtils.getResourcesGroupMapDao().countOf(resourceType, resourceId);
                break;
            }
            default: {
                throw new RuntimeException("Not supported KEY_RESOURCE_TYPE:" + resourceType.name());
            }
        }
    }

    public Long getNodes() {
        return this.nodes;
    }

    public Long getSensors() {
        return this.sensors;
    }

    public Long getTimers() {
        return this.timers;
    }

    public Long getAlarmDefinitions() {
        return this.alarmDefinitions;
    }

    public AppProperties.RESOURCE_TYPE getResourceType() {
        return this.resourceType;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public Long getResourcesGroups() {
        return this.resourcesGroups;
    }
}

