/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.jobs;

import com.xeiam.sundial.Job;
import com.xeiam.sundial.exceptions.JobInterruptException;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.db.DaoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesLogsAggregationJob
extends Job {
    private static final Logger _logger = LoggerFactory.getLogger((String)ResourcesLogsAggregationJob.class.getName());
    private static final long TRUNCATE_SENSOR_LOG_BEFORE = 1800000L;
    private static final long TRUNCATE_SENSOR_LOG_OTHERS_BEFORE = 1800000L;
    private static final long TRUNCATE_ALARM_LOG_BEFORE = 43200000L;
    private static final long TRUNCATE_TIMER_LOG_BEFORE = 43200000L;
    private static final long TRUNCATE_ALL_OTHERS = 259200000L;

    private void truncateSensorLogs() {
        DaoUtils.getResourcesLogsDao().deleteAll(AppProperties.RESOURCE_TYPE.SENSOR, System.currentTimeMillis() - 1800000L);
        DaoUtils.getResourcesLogsDao().deleteAll(AppProperties.RESOURCE_TYPE.SENSOR_VARIABLE, System.currentTimeMillis() - 1800000L);
        DaoUtils.getResourcesLogsDao().deleteAll(AppProperties.RESOURCE_TYPE.ALARM_DEFINITION, System.currentTimeMillis() - 43200000L);
        DaoUtils.getResourcesLogsDao().deleteAll(AppProperties.RESOURCE_TYPE.TIMER, System.currentTimeMillis() - 43200000L);
        DaoUtils.getResourcesLogsDao().deleteAll(null, System.currentTimeMillis() - 259200000L);
    }

    public void doRun() throws JobInterruptException {
        _logger.debug("Truncate ResourcesLogs job triggered...");
        this.truncateSensorLogs();
        _logger.debug("Truncate ResourcesLogs job completed...");
    }
}

