/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.serialport;

import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.gateway.GatewayException;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.gateway.GatewayUtils;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.gateway.serialport.SerialPortJsscImpl;
import org.mycontroller.standalone.gateway.serialport.SerialPortPi4jImpl;
import org.mycontroller.standalone.gateway.serialport.SerialPortjSerialCommImpl;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPortMonitoringThread
implements Runnable,
IGateway {
    private static final Logger _logger = LoggerFactory.getLogger((String)SerialPortMonitoringThread.class.getName());
    private IGateway serialGateway = null;
    private boolean terminated = false;
    private boolean terminate = false;
    private long RETRY_WAIT_TIME;
    private GatewaySerial gateway = null;

    public SerialPortMonitoringThread(Gateway gateway) {
        this.gateway = new GatewaySerial(gateway);
        this.RETRY_WAIT_TIME = this.gateway.getRetryFrequency() * 1000;
        this.connect();
    }

    private void connect() {
        this.gateway.setRunningDriver(this.gateway.getDriver());
        if (this.gateway.getRunningDriver() == GatewayUtils.SERIAL_PORT_DRIVER.AUTO) {
            if (AppProperties.getOsArch().startsWith("arm")) {
                this.gateway.setRunningDriver(GatewayUtils.SERIAL_PORT_DRIVER.PI4J);
            } else {
                this.gateway.setRunningDriver(GatewayUtils.SERIAL_PORT_DRIVER.JSERIALCOMM);
            }
        }
        switch (this.gateway.getRunningDriver()) {
            case JSERIALCOMM: {
                this.serialGateway = new SerialPortjSerialCommImpl(this.gateway);
                break;
            }
            case JSSC: {
                this.serialGateway = new SerialPortJsscImpl(this.gateway);
                break;
            }
            case PI4J: {
                this.serialGateway = new SerialPortPi4jImpl(this.gateway);
                break;
            }
            default: {
                this.gateway.setStatus(AppProperties.STATE.DOWN, "Unknown serial port driver...[" + (Object)((Object)this.gateway.getRunningDriver()) + "]");
                this.gateway.updateGateway();
                _logger.warn("Unknown serial port driver[{}], nothing to do..Gateway[{}]", (Object)this.gateway.getRunningDriver(), (Object)this.gateway);
                throw new RuntimeException("Unkown serial port driver[" + (Object)((Object)this.gateway.getRunningDriver()) + "] specified");
            }
        }
    }

    private void reconnect() {
        this.close();
        this.serialGateway = null;
        this.connect();
        if (this.gateway.getStatus() == AppProperties.STATE.UP) {
            _logger.info("Serial Gateway:[{}], Successfully reconnected!", (Object)this.gateway);
        } else {
            _logger.info("Serial Gateway[{}], Unable to reconnected! Will do next try after {} second(s)", (Object)this.gateway, (Object)this.gateway.getRetryFrequency());
        }
    }

    @Override
    public void run() {
        while (!this.isTerminate()) {
            long waitTime = this.RETRY_WAIT_TIME;
            while (!this.isTerminate() && waitTime > 0L) {
                try {
                    Thread.sleep(100L);
                    waitTime -= 100L;
                }
                catch (InterruptedException ex) {
                    _logger.error("Error,", (Throwable)ex);
                }
            }
            _logger.debug("Serial Gateway:[{}]", (Object)this.gateway);
            if (this.isTerminate() || this.gateway.getStatus() == AppProperties.STATE.UP) continue;
            _logger.info("Serial Gateway[{}] not connected, Reconnect initiated...", (Object)this.gateway);
            this.reconnect();
        }
        this.terminated = true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean isTerminate() {
        return this.terminate;
    }

    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    @Override
    public synchronized void write(RawMessage rawMessage) throws GatewayException {
        if (this.gateway.getStatus() != AppProperties.STATE.UP) {
            throw new GatewayException("Gateway not available! Gateway:[" + this.gateway.toString() + "]");
        }
        this.serialGateway.write(rawMessage);
    }

    @Override
    public synchronized void close() {
        try {
            this.serialGateway.close();
        }
        catch (Exception ex) {
            _logger.error("Error closing Serial Gateway[{}],", (Object)this.gateway, (Object)ex);
        }
    }

    @Override
    public synchronized GatewaySerial getGateway() {
        return this.gateway;
    }
}

