/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.serialport;

import jssc.SerialPort;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.gateway.serialport.SerialDataListenerJssc;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPortJsscImpl
implements IGateway {
    private static final Logger _logger = LoggerFactory.getLogger((String)SerialPortJsscImpl.class.getName());
    private SerialPort serialPort;
    private GatewaySerial gateway = null;

    public SerialPortJsscImpl(GatewaySerial gateway) {
        this.gateway = gateway;
        this.initialize();
    }

    @Override
    public synchronized void write(RawMessage rawMessage) {
        try {
            this.serialPort.writeBytes(rawMessage.getGWBytes());
        }
        catch (Exception ex) {
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
            this.gateway.updateGateway();
            _logger.error("Exception while writing data, ", (Throwable)ex);
        }
    }

    private void initialize() {
        String[] portNames = SerialPortList.getPortNames();
        _logger.debug("Number of serial port available:{}", (Object)portNames.length);
        for (int portNo = 0; portNo < portNames.length; ++portNo) {
            _logger.debug("SerialPortJson[{}]:{}", (Object)(portNo + 1), (Object)portNames[portNo]);
        }
        this.serialPort = new SerialPort(this.gateway.getPortName());
        try {
            this.serialPort.openPort();
            this.serialPort.setParams(this.gateway.getBaudRate().intValue(), 1, 0, 8);
            int mask = 153;
            this.serialPort.setEventsMask(mask);
            this.serialPort.addEventListener((SerialPortEventListener)new SerialDataListenerJssc(this.serialPort, this.gateway));
            _logger.debug("Serial port gateway initialized, Gateway[{}]", (Object)this.gateway);
            this.gateway.setStatus(AppProperties.STATE.UP, "Connected Successfully");
            this.gateway.updateGateway();
        }
        catch (SerialPortException ex) {
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
            this.gateway.updateGateway();
            if (ex.getMessage().contains("Port not found")) {
                _logger.error("Failed to load serial port: {}", (Object)ex.getMessage());
            }
            _logger.error("Failed to load serial port, ", (Throwable)ex);
        }
    }

    @Override
    public void close() {
        try {
            this.serialPort.closePort();
            _logger.debug("serialPort{} closed", (Object)this.serialPort.getPortName());
        }
        catch (SerialPortException ex) {
            if (ex.getMessage().contains("Port not opened")) {
                _logger.debug("unable to close the port, Error: {}", (Object)ex.getMessage());
            }
            _logger.error("unable to close the port{}", (Object)this.serialPort.getPortName(), (Object)ex);
        }
    }

    @Override
    public GatewaySerial getGateway() {
        return this.gateway;
    }
}

