/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.tables;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import org.mycontroller.standalone.db.tables.FirmwareType;
import org.mycontroller.standalone.db.tables.FirmwareVersion;

@DatabaseTable(tableName="firmware")
public class Firmware {
    public static final String KEY_ID = "id";
    public static final String KEY_TYPE_ID = "typeId";
    public static final String KEY_VERSION_ID = "versionId";
    @DatabaseField(generatedId=true, columnName="id")
    private Integer id;
    @DatabaseField(canBeNull=false, uniqueCombo=true, columnName="typeId", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=1)
    private FirmwareType type;
    @DatabaseField(canBeNull=false, uniqueCombo=true, columnName="versionId", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=1)
    private FirmwareVersion version;
    @DatabaseField(canBeNull=false)
    private Long timestamp;
    @DatabaseField(canBeNull=false)
    private Integer blocks;
    @DatabaseField(canBeNull=false)
    private Integer crc;
    @DatabaseField(canBeNull=false, dataType=DataType.SERIALIZABLE)
    private ArrayList<Byte> data;
    private String fileString;

    public String getFirmwareName() {
        if (this.type != null && this.version != null) {
            return this.type.getName() + ":" + this.version.getVersion();
        }
        return "-";
    }

    public static FirmwareBuilder builder() {
        return new FirmwareBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public FirmwareType getType() {
        return this.type;
    }

    public FirmwareVersion getVersion() {
        return this.version;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Integer getBlocks() {
        return this.blocks;
    }

    public Integer getCrc() {
        return this.crc;
    }

    public ArrayList<Byte> getData() {
        return this.data;
    }

    public String getFileString() {
        return this.fileString;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setType(FirmwareType type) {
        this.type = type;
    }

    public void setVersion(FirmwareVersion version) {
        this.version = version;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setBlocks(Integer blocks) {
        this.blocks = blocks;
    }

    public void setCrc(Integer crc) {
        this.crc = crc;
    }

    public void setData(ArrayList<Byte> data) {
        this.data = data;
    }

    public void setFileString(String fileString) {
        this.fileString = fileString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Firmware)) {
            return false;
        }
        Firmware other = (Firmware)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        FirmwareType this$type = this.getType();
        FirmwareType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        FirmwareVersion this$version = this.getVersion();
        FirmwareVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Integer this$blocks = this.getBlocks();
        Integer other$blocks = other.getBlocks();
        if (this$blocks == null ? other$blocks != null : !((Object)this$blocks).equals(other$blocks)) {
            return false;
        }
        Integer this$crc = this.getCrc();
        Integer other$crc = other.getCrc();
        if (this$crc == null ? other$crc != null : !((Object)this$crc).equals(other$crc)) {
            return false;
        }
        ArrayList<Byte> this$data = this.getData();
        ArrayList<Byte> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$fileString = this.getFileString();
        String other$fileString = other.getFileString();
        return !(this$fileString == null ? other$fileString != null : !this$fileString.equals(other$fileString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Firmware;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        FirmwareType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        FirmwareVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Integer $blocks = this.getBlocks();
        result = result * 59 + ($blocks == null ? 43 : ((Object)$blocks).hashCode());
        Integer $crc = this.getCrc();
        result = result * 59 + ($crc == null ? 43 : ((Object)$crc).hashCode());
        ArrayList<Byte> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $fileString = this.getFileString();
        result = result * 59 + ($fileString == null ? 43 : $fileString.hashCode());
        return result;
    }

    public Firmware() {
    }

    @ConstructorProperties(value={"id", "type", "version", "timestamp", "blocks", "crc", "data", "fileString"})
    public Firmware(Integer id, FirmwareType type, FirmwareVersion version, Long timestamp, Integer blocks, Integer crc, ArrayList<Byte> data, String fileString) {
        this.id = id;
        this.type = type;
        this.version = version;
        this.timestamp = timestamp;
        this.blocks = blocks;
        this.crc = crc;
        this.data = data;
        this.fileString = fileString;
    }

    public String toString() {
        return "Firmware(id=" + this.getId() + ", type=" + this.getType() + ", version=" + this.getVersion() + ", timestamp=" + this.getTimestamp() + ", blocks=" + this.getBlocks() + ", crc=" + this.getCrc() + ", data=" + this.getData() + ", fileString=" + this.getFileString() + ")";
    }

    public static class FirmwareBuilder {
        private Integer id;
        private FirmwareType type;
        private FirmwareVersion version;
        private Long timestamp;
        private Integer blocks;
        private Integer crc;
        private ArrayList<Byte> data;
        private String fileString;

        FirmwareBuilder() {
        }

        public FirmwareBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public FirmwareBuilder type(FirmwareType type) {
            this.type = type;
            return this;
        }

        public FirmwareBuilder version(FirmwareVersion version) {
            this.version = version;
            return this;
        }

        public FirmwareBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public FirmwareBuilder blocks(Integer blocks) {
            this.blocks = blocks;
            return this;
        }

        public FirmwareBuilder crc(Integer crc) {
            this.crc = crc;
            return this;
        }

        public FirmwareBuilder data(ArrayList<Byte> data) {
            this.data = data;
            return this;
        }

        public FirmwareBuilder fileString(String fileString) {
            this.fileString = fileString;
            return this;
        }

        public Firmware build() {
            return new Firmware(this.id, this.type, this.version, this.timestamp, this.blocks, this.crc, this.data, this.fileString);
        }

        public String toString() {
            return "Firmware.FirmwareBuilder(id=" + this.id + ", type=" + this.type + ", version=" + this.version + ", timestamp=" + this.timestamp + ", blocks=" + this.blocks + ", crc=" + this.crc + ", data=" + this.data + ", fileString=" + this.fileString + ")";
        }
    }
}

