/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.ResourcesLogsDao;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.db.tables.ResourcesLogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesLogsDaoImpl
extends BaseAbstractDaoImpl<ResourcesLogs, Integer>
implements ResourcesLogsDao {
    private static final Logger _logger = LoggerFactory.getLogger(ResourcesLogsDaoImpl.class);

    public ResourcesLogsDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, ResourcesLogs.class);
    }

    @Override
    public void add(ResourcesLogs resourcesLogs) {
        try {
            int count = this.getDao().create((Object)resourcesLogs);
            _logger.debug("Added a log:[{}], Create count:{}", (Object)resourcesLogs, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add a log:[{}]", (Object)resourcesLogs, (Object)ex);
        }
    }

    @Override
    public void delete(ResourcesLogs resourcesLogs) {
        try {
            int count = this.getDao().delete((Object)resourcesLogs);
            _logger.debug("ResourcesLogs:[{}] deleted, Delete count:{}", (Object)resourcesLogs, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete a log:[{}]", (Object)resourcesLogs, (Object)ex);
        }
    }

    @Override
    public void deleteAll(ResourcesLogs resourcesLogs) {
        this.deleteAll(resourcesLogs.getResourceType(), resourcesLogs.getResourceId());
    }

    @Override
    public void deleteAll(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            this.updateWhereQuery((Where<ResourcesLogs, Integer>)deleteBuilder.where(), resourceType, resourceId);
            int deleteCount = deleteBuilder.delete();
            _logger.debug("Deleted Resource:[Type:{}, KEY_ID:{}], delete count:{}", new Object[]{resourceType.getText(), resourceId, deleteCount});
        }
        catch (SQLException ex) {
            _logger.error("unable to delete Resource:[Type:{}, KEY_ID:{}]", new Object[]{resourceType.getText(), resourceId, ex});
        }
    }

    @Override
    public void deleteAll(AppProperties.RESOURCE_TYPE resourceType, Long timestamp) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            if (resourceType != null && timestamp != null) {
                deleteBuilder.where().eq("resourceType", (Object)resourceType).and().le("timestamp", (Object)timestamp);
            } else if (timestamp != null) {
                deleteBuilder.where().le("timestamp", (Object)timestamp);
            }
            int deleteCount = deleteBuilder.delete();
            _logger.debug("Deleted Resource:[Type:{}, Timestamp:{}], delete count:{}", new Object[]{resourceType, timestamp, deleteCount});
        }
        catch (SQLException ex) {
            _logger.error("unable to delete Resource:[Type:{}, Timestamp:{}]", new Object[]{resourceType.getText(), timestamp, ex});
        }
    }

    @Override
    public List<ResourcesLogs> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<ResourcesLogs> getAll(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            this.updateWhereQuery((Where<ResourcesLogs, Integer>)queryBuilder.where(), resourceType, resourceId);
            return queryBuilder.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to fetch Resource:[Type:{},KEY_ID:{}]", new Object[]{resourceType.getText(), resourceId, ex});
            return null;
        }
    }

    private void updateWhereQuery(Where<ResourcesLogs, Integer> whereQuery, AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) throws SQLException {
        whereQuery.eq("resourceType", (Object)resourceType).and().eq("resourceId", (Object)resourceId);
        switch (resourceType) {
            case SENSOR: {
                List<Integer> ids = DaoUtils.getSensorVariableDao().getSensorVariableIds(resourceId);
                if (ids.isEmpty()) break;
                whereQuery.or().eq("resourceType", (Object)AppProperties.RESOURCE_TYPE.SENSOR_VARIABLE).and().in("resourceId", ids);
                break;
            }
            case NODE: {
                Node node = DaoUtils.getNodeDao().get(resourceId);
                List<Integer> sensorIds = DaoUtils.getSensorDao().getSensorIds(node.getEui(), node.getGateway().getId());
                if (sensorIds.isEmpty()) break;
                whereQuery.or().eq("resourceType", (Object)AppProperties.RESOURCE_TYPE.SENSOR).and().in("resourceId", sensorIds);
                for (Integer sensorId : sensorIds) {
                    List<Integer> sensorVariableIds = DaoUtils.getSensorVariableDao().getSensorVariableIds(sensorId);
                    if (sensorVariableIds.isEmpty()) continue;
                    whereQuery.or().eq("resourceType", (Object)AppProperties.RESOURCE_TYPE.SENSOR_VARIABLE).and().in("resourceId", sensorVariableIds);
                }
                break;
            }
        }
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }

    @Override
    public void delete(List<Integer> ids) {
        try {
            int count = this.getDao().deleteIds(ids);
            _logger.debug("Ids:[{}] deleted, Delete count:{}", ids, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete logs:[{}]", ids, (Object)ex);
        }
    }
}

