/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.FirmwareDao;
import org.mycontroller.standalone.db.tables.Firmware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareDaoImpl
extends BaseAbstractDaoImpl<Firmware, Integer>
implements FirmwareDao {
    private static final Logger _logger = LoggerFactory.getLogger(FirmwareDaoImpl.class);

    public FirmwareDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, Firmware.class);
    }

    @Override
    public Firmware get(Firmware firmware) {
        return (Firmware)this.getById(firmware.getId());
    }

    @Override
    public Firmware get(Integer typeId, Integer versionId) {
        QueryBuilder queryBuilder = this.getDao().queryBuilder();
        try {
            queryBuilder.where().eq("typeId", (Object)typeId).and().eq("versionId", (Object)versionId);
            return (Firmware)queryBuilder.queryForFirst();
        }
        catch (SQLException ex) {
            _logger.error("unable to fetch Firmware:[typeId:{},versionId:{}]", new Object[]{typeId, versionId, ex});
            return null;
        }
    }

    @Override
    public void delete(Integer typeId, Integer versionId) {
        DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
        try {
            deleteBuilder.where().eq("typeId", (Object)typeId).and().eq("versionId", (Object)versionId);
            int count = deleteBuilder.delete();
            _logger.error("Deleted Firmware(s) count:[{}]", (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete Firmware:[typeId:{},versionId:{}]", new Object[]{typeId, versionId, ex});
        }
    }

    @Override
    public List<Firmware> getAllFirmwareByType(int typeId) {
        return this.getAll(true, typeId);
    }

    @Override
    public List<Firmware> getAllFirmwareByVersion(int versionId) {
        return this.getAll(false, versionId);
    }

    private List<Firmware> getAll(Boolean isType, Integer id) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.selectColumns(new String[]{"id", "typeId", "versionId", "timestamp", "blocks", "crc"});
            if (isType != null) {
                if (isType.booleanValue()) {
                    queryBuilder.where().eq("typeId", (Object)id);
                } else {
                    queryBuilder.where().eq("versionId", (Object)id);
                }
            }
            queryBuilder.orderBy("typeId", true).orderBy("versionId", true);
            return queryBuilder.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get selected type[isType:{},id:{}]", new Object[]{isType, id, ex});
            return null;
        }
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }

    @Override
    public List<Firmware> getAll(List<Integer> ids) {
        return this.getAll("id", ids);
    }
}

