/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.settings;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.api.jaxrs.mapper.About;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsUtils {
    private static final Logger _logger = LoggerFactory.getLogger((String)SettingsUtils.class.getName());

    private SettingsUtils() {
    }

    public static String getValue(String key) {
        return SettingsUtils.getValue(key, key);
    }

    public static String getValue(String key, String subKey) {
        Settings settings = DaoUtils.getSettingsDao().get(key, subKey);
        return settings != null ? settings.getValue() : null;
    }

    public static Settings getSettings(String key, String subKey) {
        return DaoUtils.getSettingsDao().get(key, subKey);
    }

    public static void updateValue(String key, Object value) {
        SettingsUtils.updateValue(key, key, value);
    }

    public static void updateValue(String key, String subKey, Object value) {
        DaoUtils.getSettingsDao().update(key, subKey, value != null ? String.valueOf(value) : null);
    }

    public static void updateValue(String key, String subKey, Object value, Object altValue) {
        DaoUtils.getSettingsDao().update(key, subKey, value != null ? String.valueOf(value) : null, altValue != null ? String.valueOf(altValue) : null);
    }

    public static void updateStaticJsonInformationFile() {
        String fileLocation = ObjectFactory.getAppProperties().getWebFileLocation() + "configMyController.json";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            _logger.debug("controller information static file location:[{}]", (Object)fileLocation);
            objectMapper.writeValue(new File(fileLocation), (Object)new About());
        }
        catch (Exception ex) {
            _logger.error("Unable to write static json information file! location:[{}]", (Object)fileLocation, (Object)ex);
        }
    }

    public static void updateAllSettings() {
        ObjectFactory.getAppProperties().loadPropertiesFromDb();
        SettingsUtils.updateStaticJsonInformationFile();
    }
}

