/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.settings.SettingsUtils;

@JsonTypeName(value="locationSettings")
public class LocationSettings {
    public static final String KEY_LOCATION = "location";
    public static final String SKEY_NAME = "name";
    public static final String SKEY_LATITUDE = "latitude";
    public static final String SKEY_LONGITUDE = "longitude";
    public static final String SKEY_SUNRISE_TIME = "sunrise";
    public static final String SKEY_SUNSET_TIME = "sunset";
    private String name;
    private String latitude;
    private String longitude;
    private Long sunriseTime;
    private Long sunsetTime;

    public static LocationSettings get() {
        return LocationSettings.builder().name(LocationSettings.getValue(SKEY_NAME)).latitude(LocationSettings.getValue(SKEY_LATITUDE)).longitude(LocationSettings.getValue(SKEY_LONGITUDE)).sunriseTime(NumericUtils.getLong(LocationSettings.getValue(SKEY_SUNRISE_TIME))).sunsetTime(NumericUtils.getLong(LocationSettings.getValue(SKEY_SUNSET_TIME))).build();
    }

    public void save() {
        LocationSettings.updateValue(SKEY_NAME, this.name);
        LocationSettings.updateValue(SKEY_LATITUDE, this.latitude);
        LocationSettings.updateValue(SKEY_LONGITUDE, this.longitude);
    }

    private static String getValue(String subKey) {
        return SettingsUtils.getValue(KEY_LOCATION, subKey);
    }

    private static void updateValue(String subKey, Object value) {
        SettingsUtils.updateValue(KEY_LOCATION, subKey, value);
    }

    @JsonIgnore
    public void updateInternal() {
        LocationSettings.updateValue(SKEY_SUNRISE_TIME, this.sunriseTime);
        LocationSettings.updateValue(SKEY_SUNSET_TIME, this.sunsetTime);
    }

    public static LocationSettingsBuilder builder() {
        return new LocationSettingsBuilder();
    }

    public String toString() {
        return "LocationSettings(name=" + this.getName() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", sunriseTime=" + this.getSunriseTime() + ", sunsetTime=" + this.getSunsetTime() + ")";
    }

    public String getName() {
        return this.name;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public Long getSunriseTime() {
        return this.sunriseTime;
    }

    public Long getSunsetTime() {
        return this.sunsetTime;
    }

    public LocationSettings() {
    }

    @ConstructorProperties(value={"name", "latitude", "longitude", "sunriseTime", "sunsetTime"})
    public LocationSettings(String name, String latitude, String longitude, Long sunriseTime, Long sunsetTime) {
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.sunriseTime = sunriseTime;
        this.sunsetTime = sunsetTime;
    }

    public static class LocationSettingsBuilder {
        private String name;
        private String latitude;
        private String longitude;
        private Long sunriseTime;
        private Long sunsetTime;

        LocationSettingsBuilder() {
        }

        public LocationSettingsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LocationSettingsBuilder latitude(String latitude) {
            this.latitude = latitude;
            return this;
        }

        public LocationSettingsBuilder longitude(String longitude) {
            this.longitude = longitude;
            return this;
        }

        public LocationSettingsBuilder sunriseTime(Long sunriseTime) {
            this.sunriseTime = sunriseTime;
            return this;
        }

        public LocationSettingsBuilder sunsetTime(Long sunsetTime) {
            this.sunsetTime = sunsetTime;
            return this;
        }

        public LocationSettings build() {
            return new LocationSettings(this.name, this.latitude, this.longitude, this.sunriseTime, this.sunsetTime);
        }

        public String toString() {
            return "LocationSettings.LocationSettingsBuilder(name=" + this.name + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", sunriseTime=" + this.sunriseTime + ", sunsetTime=" + this.sunsetTime + ")";
        }
    }
}

