/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.message;

import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.gateway.GatewayException;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.message.IMessageProcessEngine;
import org.mycontroller.standalone.message.RawMessage;
import org.mycontroller.standalone.mysensors.MySensorsMessageEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMonitorThread
implements Runnable {
    private static Logger _logger = LoggerFactory.getLogger((String)MessageMonitorThread.class.getName());
    private static boolean terminationIssued = false;
    private static boolean terminated = false;
    private IMessageProcessEngine mySensorsEngine = new MySensorsMessageEngine();
    public static final long MYS_MSG_DELAY = 30L;

    public static boolean isTerminationIssued() {
        return terminationIssued;
    }

    public static synchronized void setTerminationIssued(boolean terminationIssued) {
        MessageMonitorThread.terminationIssued = terminationIssued;
        long start = System.currentTimeMillis();
        long waitTime = 300000L;
        while (!terminated) {
            try {
                Thread.sleep(10L);
                if (System.currentTimeMillis() - start < waitTime) continue;
                _logger.warn("Unable to stop MessageMonitorThread on specied wait time[{}ms]", (Object)waitTime);
                break;
            }
            catch (InterruptedException ex) {
                _logger.debug("Exception in xsleep thread,", (Throwable)ex);
            }
        }
        _logger.debug("MessageMonitorThread terminated");
    }

    private void processRawMessage() {
        while (!ObjectFactory.getRawMessageQueue().isEmpty() && !MessageMonitorThread.isTerminationIssued()) {
            RawMessage rawMessage = ObjectFactory.getRawMessageQueue().getMessage();
            _logger.debug("Processing message:[{}]", (Object)rawMessage);
            if (ObjectFactory.getGateway(rawMessage.getGatewayId()) != null) {
                try {
                    switch (ObjectFactory.getGateway(rawMessage.getGatewayId()).getGateway().getNetworkType()) {
                        case MY_SENSORS: {
                            this.mySensorsEngine.executeMessage(rawMessage);
                            break;
                        }
                        default: {
                            _logger.warn("Not implemented this type:{}", (Object)ObjectFactory.getGateway(rawMessage.getGatewayId()).getGateway().getNetworkType());
                        }
                    }
                    if (ObjectFactory.getRawMessageQueue().isEmpty()) continue;
                    Thread.sleep(30L);
                }
                catch (GatewayException ex) {
                    if (ex.getMessage().contains(IGateway.GATEWAY_STATUS.GATEWAY_ERROR.toString())) {
                        _logger.error("Problem with Gateway!, RawMessage[{}], Error:[{}]", (Object)rawMessage, (Object)ex.getMessage());
                        continue;
                    }
                    _logger.error("RawMessage[{}] throws exception while processing!, ", (Object)rawMessage, (Object)ex);
                }
                catch (Exception ex) {
                    _logger.error("RawMessage[{}] throws exception while processing!, ", (Object)rawMessage, (Object)ex);
                }
                continue;
            }
            Gateway gateway = (Gateway)DaoUtils.getGatewayDao().getById(rawMessage.getGatewayId());
            _logger.error("Gateway not available! dropping message... Gateway[{}], RawMessage[{}]", (Object)gateway, (Object)rawMessage);
        }
        if (!ObjectFactory.getRawMessageQueue().isEmpty()) {
            _logger.warn("MessageMonitorThread terminating with {} message(s) in queue!", (Object)ObjectFactory.getRawMessageQueue().getQueueSize());
        }
    }

    @Override
    public void run() {
        try {
            _logger.debug("MessageMonitorThread new thread started.");
            while (!MessageMonitorThread.isTerminationIssued()) {
                try {
                    this.processRawMessage();
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    _logger.debug("Exception in sleep thread,", (Throwable)ex);
                }
            }
            if (MessageMonitorThread.isTerminationIssued()) {
                _logger.debug("MessageMonitorThread termination issues. Terminating.");
                terminated = true;
            }
        }
        catch (Exception ex) {
            terminated = true;
            _logger.error("MessageMonitorThread terminated!, ", (Throwable)ex);
        }
    }

    public static boolean isTerminated() {
        return terminated;
    }
}

