/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.group;

import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.PayloadOperation;
import org.mycontroller.standalone.db.tables.ResourcesGroup;
import org.mycontroller.standalone.db.tables.ResourcesGroupMap;
import org.mycontroller.standalone.gateway.GatewayUtils;
import org.mycontroller.standalone.model.ResourceModel;

public class ResourcesGroupUtils {
    private ResourcesGroupUtils() {
    }

    public static void turnONresourcesGroup(List<Integer> ids) {
        for (Integer id : ids) {
            ResourcesGroupUtils.changeStateResourcesGroup(id, AppProperties.STATE.ON);
        }
    }

    public static void turnOFFresourcesGroup(List<Integer> ids) {
        for (Integer id : ids) {
            ResourcesGroupUtils.changeStateResourcesGroup(id, AppProperties.STATE.OFF);
        }
    }

    public static void turnONresourcesGroup(Integer id) {
        ResourcesGroupUtils.changeStateResourcesGroup(id, AppProperties.STATE.ON);
    }

    public static void turnOFFresourcesGroup(Integer id) {
        ResourcesGroupUtils.changeStateResourcesGroup(id, AppProperties.STATE.OFF);
    }

    private static void changeStateResourcesGroup(Integer id, AppProperties.STATE state) {
        ResourcesGroup resourcesGroup = DaoUtils.getResourcesGroupDao().get(id);
        if (resourcesGroup.getState() == state) {
            return;
        }
        List<ResourcesGroupMap> resourcesGroupMaps = DaoUtils.getResourcesGroupMapDao().getAll(id);
        for (ResourcesGroupMap resourcesGroupMap : resourcesGroupMaps) {
            ResourceModel resourceModel = new ResourceModel(resourcesGroupMap.getResourceType(), resourcesGroupMap.getResourceId());
            PayloadOperation operation = null;
            if (AppProperties.STATE.ON == state) {
                operation = new PayloadOperation(resourcesGroupMap.getPayloadOn());
            } else if (AppProperties.STATE.OFF == state) {
                operation = new PayloadOperation(resourcesGroupMap.getPayloadOff());
            } else {
                return;
            }
            if (resourceModel.getResourceType() == AppProperties.RESOURCE_TYPE.GATEWAY) {
                GatewayUtils.executeGatewayOperation(resourceModel, operation);
                continue;
            }
            ObjectFactory.getIActionEngine(resourceModel.getNetworkType()).executeSendPayload(resourceModel, operation);
        }
        resourcesGroup.setState(state);
        resourcesGroup.setStateSince(System.currentTimeMillis());
        DaoUtils.getResourcesGroupDao().update(resourcesGroup);
    }
}

