/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.serialport;

import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDataListenerJssc
implements SerialPortEventListener {
    private static Logger _logger = LoggerFactory.getLogger((String)SerialDataListenerJssc.class.getName());
    private SerialPort serialPort;
    private GatewaySerial gateway;
    StringBuilder message = new StringBuilder();

    public SerialDataListenerJssc(SerialPort serialPort, GatewaySerial gateway) {
        this.serialPort = serialPort;
        this.gateway = gateway;
    }

    public void serialEvent(SerialPortEvent event) {
        if (event.isRXCHAR() && event.getEventValue() > 0) {
            try {
                byte[] buffer;
                for (byte b : buffer = this.serialPort.readBytes()) {
                    if (b == 10 && this.message.length() > 0) {
                        String toProcess = this.message.toString();
                        _logger.debug("Received a message:[{}]", (Object)toProcess);
                        ObjectFactory.getRawMessageQueue().putMessage(new RawMessage(this.gateway.getId(), toProcess));
                        this.message.setLength(0);
                        continue;
                    }
                    if (b != 10) {
                        _logger.trace("Received a char:[{}]", (Object)Character.valueOf((char)b));
                        this.message.append((char)b);
                        continue;
                    }
                    if (this.message.length() >= 1000) {
                        _logger.warn("Serial receive buffer size reached to MAX level[{} chars], Now clearing the buffer. Existing data:[{}]", (Object)1000, (Object)this.message.toString());
                        this.message.setLength(0);
                        continue;
                    }
                    _logger.debug("Received MESSAGE_SPLITTER and current message length is ZERO! Nothing to do");
                }
            }
            catch (SerialPortException ex) {
                _logger.error("Serail Event Exception, ", (Throwable)ex);
                this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
                this.gateway.updateGateway();
                this.message.setLength(0);
            }
            catch (Exception ex) {
                _logger.error("Exception,", (Throwable)ex);
                this.message.setLength(0);
            }
        }
    }
}

