/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.ethernet;

import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.gateway.GatewayEthernet;
import org.mycontroller.standalone.gateway.GatewayException;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.gateway.ethernet.EthernetGatewayActionThread;
import org.mycontroller.standalone.message.RawMessage;

public class EthernetGatewayImpl
implements IGateway {
    private EthernetGatewayActionThread monitoringThread = null;

    public EthernetGatewayImpl(Gateway gateway) {
        if (this.monitoringThread == null) {
            this.monitoringThread = new EthernetGatewayActionThread(new GatewayEthernet(gateway));
            new Thread(this.monitoringThread).start();
        }
    }

    @Override
    public synchronized void close() {
        this.monitoringThread.close();
    }

    @Override
    public synchronized void write(RawMessage rawMessage) throws GatewayException {
        this.monitoringThread.write(rawMessage);
    }

    @Override
    public GatewayEthernet getGateway() {
        if (this.monitoringThread != null) {
            return this.monitoringThread.getGateway();
        }
        return null;
    }
}

