/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.ResourcesGroupMapDao;
import org.mycontroller.standalone.db.tables.ResourcesGroup;
import org.mycontroller.standalone.db.tables.ResourcesGroupMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesGroupMapDaoImpl
extends BaseAbstractDaoImpl<ResourcesGroupMap, Integer>
implements ResourcesGroupMapDao {
    private static final Logger _logger = LoggerFactory.getLogger(ResourcesGroupMapDaoImpl.class);

    public ResourcesGroupMapDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, ResourcesGroupMap.class);
    }

    @Override
    public void create(ResourcesGroupMap resourcesGroupMap) {
        try {
            Integer count = this.getDao().create((Object)resourcesGroupMap);
            _logger.debug("Created ResourcesGroupMap:[{}], Create count:{}", (Object)resourcesGroupMap, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add ResourcesGroupMap:[{}]", (Object)resourcesGroupMap, (Object)ex);
        }
    }

    @Override
    public void createOrUpdate(ResourcesGroupMap resourcesGroupMap) {
        try {
            Dao.CreateOrUpdateStatus status = this.getDao().createOrUpdate((Object)resourcesGroupMap);
            _logger.debug("CreateOrUpdate ResourcesGroupMap:[{}],Create:{},Update:{},Lines Changed:{}", new Object[]{resourcesGroupMap, status.isCreated(), status.isUpdated(), status.getNumLinesChanged()});
        }
        catch (SQLException ex) {
            _logger.error("unable to CreateOrUpdate ResourcesGroup:[{}]", (Object)resourcesGroupMap, (Object)ex);
        }
    }

    @Override
    public void update(ResourcesGroupMap resourcesGroupMap) {
        try {
            Integer count = this.getDao().update((Object)resourcesGroupMap);
            _logger.debug("Updated ResourcesGroupMap:[{}], Create count:{}", (Object)resourcesGroupMap, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to update ResourcesGroupMap:[{}]", (Object)resourcesGroupMap, (Object)ex);
        }
    }

    @Override
    public void delete(ResourcesGroupMap resourcesGroupMap) {
        this.delete(null, resourcesGroupMap.getId(), null, null);
    }

    @Override
    public void delete(Integer id) {
        this.delete(id, null, null, null);
    }

    @Override
    public void delete(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        this.delete(null, null, resourceType, resourceId);
    }

    @Override
    public void delete(ResourcesGroup resourcesGroup) {
        this.delete(null, resourcesGroup.getId(), null, null);
    }

    private void delete(Integer id, Integer resourcesGroupId, AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        try {
            int deleteCount = 0;
            if (id != null) {
                deleteCount = this.getDao().deleteById((Object)id);
            } else if (resourcesGroupId != null) {
                DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
                deleteBuilder.where().eq("groupId", (Object)resourcesGroupId);
                deleteCount = deleteBuilder.delete();
            } else if (resourceType != null && resourceId != null) {
                DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
                deleteBuilder.where().eq("resourceType", (Object)resourceType).and().eq("resourceId", (Object)resourceId);
                deleteCount = deleteBuilder.delete();
            } else {
                _logger.warn("all values should not be null!");
            }
            _logger.debug("Deleted [id:{}, resourceGroupId:{}, resourceType:{}, resourceId:{}], delete count:{}", new Object[]{id, resourcesGroupId, resourceType, resourceId, deleteCount});
        }
        catch (SQLException ex) {
            _logger.debug("unable to deleted [id:{}, resourceGroupId:{}, resourceType:{}, resourceId:{}]", new Object[]{id, resourcesGroupId, resourceType, resourceId, ex});
        }
    }

    @Override
    public ResourcesGroupMap get(Integer id) {
        try {
            return (ResourcesGroupMap)this.getDao().queryForId((Object)id);
        }
        catch (SQLException ex) {
            _logger.error("unable to get id:[{}]", (Object)id, (Object)ex);
            return null;
        }
    }

    @Override
    public List<ResourcesGroupMap> getAll(Integer resourceGroupId) {
        return this.getAllPrivate(resourceGroupId, null, null);
    }

    @Override
    public List<ResourcesGroupMap> getAll(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        return this.getAllPrivate(null, resourceType, resourceId);
    }

    @Override
    public List<ResourcesGroupMap> getAll() {
        return this.getAllPrivate(null, null, null);
    }

    @Override
    public List<ResourcesGroupMap> getAll(ResourcesGroup resourcesGroup) {
        return this.getAllPrivate(resourcesGroup.getId(), null, null);
    }

    private List<ResourcesGroupMap> getAllPrivate(Integer resourceGroupId, AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        try {
            if (resourceGroupId == null && resourceType == null && resourceId == null) {
                return this.getDao().queryForAll();
            }
            if (resourceGroupId != null) {
                QueryBuilder queryBuilder = this.getDao().queryBuilder();
                queryBuilder.where().eq("groupId", (Object)resourceGroupId);
                return queryBuilder.query();
            }
            if (resourceType != null && resourceId != null) {
                QueryBuilder queryBuilder = this.getDao().queryBuilder();
                queryBuilder.where().eq("resourceType", (Object)resourceType).and().eq("resourceId", (Object)resourceId);
                return queryBuilder.query();
            }
            if (resourceType != null) {
                QueryBuilder queryBuilder = this.getDao().queryBuilder();
                queryBuilder.where().eq("resourceType", (Object)resourceType);
                return queryBuilder.query();
            }
            return null;
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void delete(List<Integer> ids) {
        try {
            int deleteCount = this.getDao().deleteIds(ids);
            _logger.debug("Deleted [ids:{}], delete count:{}", ids, (Object)deleteCount);
        }
        catch (SQLException ex) {
            _logger.debug("unable to deleted [ids:{}]", ids, (Object)ex);
        }
    }

    @Override
    public long countOf(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("resourceType", (Object)resourceType).and().eq("resourceId", (Object)resourceId);
            return queryBuilder.countOf();
        }
        catch (SQLException ex) {
            _logger.error("unable to get items count for resource[Type:{}, Id:{}]", new Object[]{resourceType, resourceId, ex});
            return 0L;
        }
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id", "groupId");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }
}

