/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs.mapper;

import java.util.HashMap;
import lombok.NonNull;

public class Query {
    public static final Long MAX_ITEMS_PER_PAGE = 10L;
    public static final String PAGE_LIMIT = "pageLimit";
    public static final String PAGE = "page";
    public static final String ORDER = "order";
    public static final String ORDER_BY = "orderBy";
    public static final String ORDER_ASC = "asc";
    private Long totalItems;
    private Long filteredCount;
    private long pageLimit;
    private long page;
    private String orderBy;
    @NonNull
    private String order;
    private HashMap<String, Object> filters;

    public Long getStartingRow() {
        return (this.getPage() - 1L) * this.getPageLimit();
    }

    Query(Long totalItems, Long filteredCount, long pageLimit, long page, String orderBy, @NonNull String order, HashMap<String, Object> filters) {
        if (order == null) {
            throw new NullPointerException(ORDER);
        }
        this.totalItems = totalItems;
        this.filteredCount = filteredCount;
        this.pageLimit = pageLimit;
        this.page = page;
        this.orderBy = orderBy;
        this.order = order;
        this.filters = filters;
    }

    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    public Long getTotalItems() {
        return this.totalItems;
    }

    public Long getFilteredCount() {
        return this.filteredCount;
    }

    public long getPageLimit() {
        return this.pageLimit;
    }

    public long getPage() {
        return this.page;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    @NonNull
    public String getOrder() {
        return this.order;
    }

    public HashMap<String, Object> getFilters() {
        return this.filters;
    }

    public void setTotalItems(Long totalItems) {
        this.totalItems = totalItems;
    }

    public void setFilteredCount(Long filteredCount) {
        this.filteredCount = filteredCount;
    }

    public void setPageLimit(long pageLimit) {
        this.pageLimit = pageLimit;
    }

    public void setPage(long page) {
        this.page = page;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setOrder(@NonNull String order) {
        if (order == null) {
            throw new NullPointerException(ORDER);
        }
        this.order = order;
    }

    public void setFilters(HashMap<String, Object> filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalItems = this.getTotalItems();
        Long other$totalItems = other.getTotalItems();
        if (this$totalItems == null ? other$totalItems != null : !((Object)this$totalItems).equals(other$totalItems)) {
            return false;
        }
        Long this$filteredCount = this.getFilteredCount();
        Long other$filteredCount = other.getFilteredCount();
        if (this$filteredCount == null ? other$filteredCount != null : !((Object)this$filteredCount).equals(other$filteredCount)) {
            return false;
        }
        if (this.getPageLimit() != other.getPageLimit()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        String this$orderBy = this.getOrderBy();
        String other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        HashMap<String, Object> this$filters = this.getFilters();
        HashMap<String, Object> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalItems = this.getTotalItems();
        result = result * 59 + ($totalItems == null ? 43 : ((Object)$totalItems).hashCode());
        Long $filteredCount = this.getFilteredCount();
        result = result * 59 + ($filteredCount == null ? 43 : ((Object)$filteredCount).hashCode());
        long $pageLimit = this.getPageLimit();
        result = result * 59 + (int)($pageLimit >>> 32 ^ $pageLimit);
        long $page = this.getPage();
        result = result * 59 + (int)($page >>> 32 ^ $page);
        String $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        HashMap<String, Object> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "Query(totalItems=" + this.getTotalItems() + ", filteredCount=" + this.getFilteredCount() + ", pageLimit=" + this.getPageLimit() + ", page=" + this.getPage() + ", orderBy=" + this.getOrderBy() + ", order=" + this.getOrder() + ", filters=" + this.getFilters() + ")";
    }

    public static class QueryBuilder {
        private Long totalItems;
        private Long filteredCount;
        private long pageLimit;
        private long page;
        private String orderBy;
        private String order;
        private HashMap<String, Object> filters;

        QueryBuilder() {
        }

        public QueryBuilder totalItems(Long totalItems) {
            this.totalItems = totalItems;
            return this;
        }

        public QueryBuilder filteredCount(Long filteredCount) {
            this.filteredCount = filteredCount;
            return this;
        }

        public QueryBuilder pageLimit(long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public QueryBuilder page(long page) {
            this.page = page;
            return this;
        }

        public QueryBuilder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public QueryBuilder order(String order) {
            this.order = order;
            return this;
        }

        public QueryBuilder filters(HashMap<String, Object> filters) {
            this.filters = filters;
            return this;
        }

        public Query build() {
            return new Query(this.totalItems, this.filteredCount, this.pageLimit, this.page, this.orderBy, this.order, this.filters);
        }

        public String toString() {
            return "Query.QueryBuilder(totalItems=" + this.totalItems + ", filteredCount=" + this.filteredCount + ", pageLimit=" + this.pageLimit + ", page=" + this.page + ", orderBy=" + this.orderBy + ", order=" + this.order + ", filters=" + this.filters + ")";
        }
    }
}

