/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.api.jaxrs.mapper.TypesIdNameMapper;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.api.jaxrs.utils.TypesUtils;
import org.mycontroller.standalone.auth.USER_ROLE;

@Path(value="/rest/types")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TypesHandler {
    @GET
    @Path(value="/gatewayTypes")
    public Response getGatewayTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getGatewayTypes());
    }

    @GET
    @Path(value="/gatewayNetworkTypes")
    public Response getGatewaySubTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getGatewayNetworkTypes());
    }

    @GET
    @Path(value="/gatewaySerialDrivers")
    public Response getGatewaySerialDrivers() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getGatewaySerialDrivers());
    }

    @GET
    @Path(value="/nodeTypes")
    public Response getNodeTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getNodeTypes());
    }

    @GET
    @Path(value="/resourceTypes")
    public Response getResourceTypes(@QueryParam(value="resourceType") String resourceType) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getResourceTypes(resourceType));
    }

    @GET
    @Path(value="/resources")
    public Response getResources(@QueryParam(value="resourceType") String resourceType) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getResources(resourceType));
    }

    @GET
    @Path(value="/gateways")
    public Response getGateways() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getGateways());
    }

    @GET
    @Path(value="/nodes")
    public Response getNodes(@QueryParam(value="gatewayId") Integer gatewayId) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getNodes(gatewayId));
    }

    @GET
    @Path(value="/sensors")
    public Response getSensors(@QueryParam(value="nodeId") Integer nodeId) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getSensors(nodeId));
    }

    @GET
    @Path(value="/sensorVariables")
    public Response getSensorVaribles(@QueryParam(value="sensorId") Integer sensorId) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getSensorVariables(sensorId));
    }

    @GET
    @Path(value="/resourcesGroups")
    public Response getResourcesGroups() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getResourcesGroups());
    }

    @GET
    @Path(value="/timers")
    public Response getTimers() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getTimers());
    }

    @GET
    @Path(value="/alarmDefinitions")
    public Response getAlarmDefinitions() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getAlarmDefinitions());
    }

    @GET
    @Path(value="/firmwares")
    public Response getFirmwares() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getFirmwares());
    }

    @GET
    @Path(value="/firmwareTypes")
    public Response getFirmwareTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getFirmwareTypes());
    }

    @GET
    @Path(value="/firmwareVersions")
    public Response getFirmwareVersions() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getFirmwareVersions());
    }

    @GET
    @Path(value="/sensorTypes")
    public Response getSensorTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getSensorTypes());
    }

    @GET
    @Path(value="/sensorVariableTypes")
    public Response getSensorVariableTypes(@QueryParam(value="sensorType") String sensorType, @QueryParam(value="sensorId") Integer sensorId) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getSensorVariableTypes(MYCMessages.MESSAGE_TYPE_PRESENTATION.fromString(sensorType), sensorId));
    }

    @GET
    @Path(value="/alarmTriggerTypes")
    public Response getAlarmTriggers(@QueryParam(value="resourceType") String resourceType) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getAlarmTriggerTypes(resourceType));
    }

    @GET
    @Path(value="/alarmThresholdTypes")
    public Response getAlarmThresholdTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getAlarmThresholdTypes());
    }

    @GET
    @Path(value="/alarmNotificationTypes")
    public Response getAlarmTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getAlarmNotificationTypes());
    }

    @GET
    @Path(value="/alarmDampeningTypes")
    public Response getAlarmDampeningTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getAlarmDampeningTypes());
    }

    @GET
    @Path(value="/stateTypes")
    public Response getStateTypes(@QueryParam(value="resourceType") String resourceType) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getStateTypes(resourceType));
    }

    @GET
    @Path(value="/timerTypes")
    public Response getTimerTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getTimerTypes());
    }

    @GET
    @Path(value="/timerFrequencyTypes")
    public Response getTimerFrequencies() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getTimerFrequencyTypes());
    }

    @GET
    @Path(value="/timerWeekDays")
    public Response getTimerDays(@QueryParam(value="allDays") Boolean allDays) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getTimerWeekDays(allDays != null ? allDays : false));
    }

    @GET
    @Path(value="/sensorVariableMapper")
    public Response getSensorVariableMapper() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getVariableMapperList());
    }

    @GET
    @Path(value="/sensorVariableMapperByType")
    public Response getSensorVariableTypesAll(@QueryParam(value="sensorType") String sensorType) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getSensorVariableMapperByType(MYCMessages.MESSAGE_TYPE_PRESENTATION.fromString(sensorType)));
    }

    @PUT
    @Path(value="/sensorVariableMapper")
    public Response updateSensorVariableMapper(TypesIdNameMapper idNameMapper) {
        TypesUtils.updateVariableMap(idNameMapper);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/languages")
    public Response getLanguages() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getLanguages());
    }

    @GET
    @Path(value="/roles")
    public Response getUserRoles() {
        return RestUtils.getResponse(Response.Status.OK, USER_ROLE.values());
    }

    @GET
    @Path(value="/configUnitTypes")
    public Response getMysConfigTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getConfigUnitTypes());
    }

    @GET
    @Path(value="/graphInterpolate")
    public Response getGraphInterpolateTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getGraphInterpolateTypes());
    }

    @GET
    @Path(value="/sensorVariableTypes")
    public Response getSensorValueTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getSensorValueTypes());
    }

    @GET
    @Path(value="/graphSensorVariableTypes/{sensorRefId}")
    public Response getGraphSensorVariableTypes(@PathParam(value="sensorRefId") int sensorRefId) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getGraphSensorVariableTypes(sensorRefId));
    }

    @GET
    @Path(value="/messageTypes")
    public Response getMessageTypes() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getMessageTypes());
    }

    @GET
    @Path(value="/messageSubTypes/{messageType}")
    public Response getMessageSubTypes(@PathParam(value="messageType") int messageType) {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getMessageSubTypes(messageType));
    }

    @GET
    @Path(value="/timeFormats")
    public Response getTime12h24hformats() {
        return RestUtils.getResponse(Response.Status.OK, TypesUtils.getTimeFormats());
    }
}

