/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.alarm;

import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.alarm.INotification;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.sms.SMSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationSMS
implements INotification {
    private static final Logger _logger = LoggerFactory.getLogger(NotificationSMS.class);
    private String toPhoneNumber;
    private String customMessage;
    private AlarmDefinition alarmDefinition;

    public NotificationSMS(AlarmDefinition alarmDefinition) {
        this.alarmDefinition = alarmDefinition;
        this.toPhoneNumber = alarmDefinition.getVariable1();
        this.customMessage = alarmDefinition.getVariable2();
    }

    public String getToPhoneNumber() {
        return this.toPhoneNumber;
    }

    public String toString() {
        return this.toPhoneNumber;
    }

    @Override
    public AlarmDefinition getAlarmDefinition() {
        return this.alarmDefinition;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    @Override
    public void execute(String actualValue) {
        if (this.toPhoneNumber == null) {
            throw new RuntimeException("Cannot execute send SMS without phone number! AlarmDefination name: " + this.alarmDefinition.getName());
        }
        try {
            if (this.customMessage != null) {
                SMSUtils.sendSMS(this.toPhoneNumber, this.customMessage);
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("AlarmDefinition: [").append(this.alarmDefinition.getName()).append("], Cond: ").append(AlarmUtils.getConditionString(this.alarmDefinition)).append(AlarmUtils.getSensorUnit(this.alarmDefinition, true)).append(", Present Value:").append(actualValue).append(AlarmUtils.getSensorUnit(this.alarmDefinition, false)).append(", ").append(AlarmUtils.getResourceString(this.alarmDefinition, false)).append("\nwww.mycontroller.org");
                SMSUtils.sendSMS(this.toPhoneNumber, builder.toString());
            }
        }
        catch (Exception ex) {
            _logger.error("Exception,", (Throwable)ex);
        }
    }
}

