/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.common.retry.policies;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.modules.common.retry.policies.RetryContextUtil;

class RetryWork
implements Work {
    private final CountDownLatch workDoneLatch = new CountDownLatch(1);
    private final AtomicBoolean forceReconnection = new AtomicBoolean(true);
    private final AtomicReference<RetryContext> retryContextReference = new AtomicReference();
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MuleContext muleContext;
    private final WorkManager workManager;
    private final RetryPolicyTemplate retryPolicyTemplate;
    private final RetryCallback retryCallback;

    RetryWork(MuleContext muleContext, WorkManager workManager, RetryPolicyTemplate retryPolicyTemplate, RetryCallback retryCallback) {
        this.muleContext = muleContext;
        this.workManager = workManager;
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.retryCallback = retryCallback;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean workCompletedWhileWaiting = this.workDoneLatch.await(timeout, unit);
        if (workCompletedWhileWaiting) {
            this.forceReconnection.set(false);
        }
        return workCompletedWhileWaiting;
    }

    public RetryContext getRetryContextResult() {
        return this.retryContextReference.get();
    }

    public void run() {
        try {
            RetryContext retryContext = this.retryPolicyTemplate.execute(this.retryCallback, this.workManager);
            this.retryContextReference.set(retryContext);
            this.workDoneLatch.countDown();
            String retryContextDescription = retryContext.getDescription();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The retry policy has returned: " + retryContext + " (" + retryContextDescription + ")"));
            }
            if (this.forceReconnection.get()) {
                RetryContextUtil.recoverConnectables(this.muleContext, retryContextDescription);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.logger.error((Object)"The asynchronous retry policy has failed!", (Throwable)e);
        }
    }

    public void release() {
        this.workDoneLatch.countDown();
    }
}

