/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.common.retry.policies;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.transport.MessageReceiver;
import org.mule.transport.AbstractConnector;

abstract class RetryContextUtil {
    private static final Log LOGGER = LogFactory.getLog(RetryContextUtil.class);

    private RetryContextUtil() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    static void recoverConnectables(MuleContext muleContext, String retryContextDescription) {
        Collection connectors = muleContext.getRegistry().lookupObjects(AbstractConnector.class);
        for (AbstractConnector connector : connectors) {
            if (!RetryContextUtil.hasConnectorBeenReconnected(retryContextDescription, connector)) continue;
            RetryContextUtil.recoverConnector(connector);
            RetryContextUtil.recoverMessageReceivers(connector);
        }
    }

    private static void recoverConnector(AbstractConnector connector) {
        LOGGER.info((Object)("Recovering connector: " + connector));
        try {
            connector.start();
            connector.connect();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error when recovering connector: " + connector), (Throwable)e);
        }
    }

    private static void recoverMessageReceivers(AbstractConnector connector) {
        for (MessageReceiver messageReceiver : connector.getReceivers("*")) {
            LOGGER.info((Object)("Recovering message receiver: " + messageReceiver));
            try {
                messageReceiver.connect();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error when recovering message receiver: " + messageReceiver), (Throwable)e);
            }
        }
    }

    private static boolean hasConnectorBeenReconnected(String retryContextDescription, AbstractConnector connector) {
        return retryContextDescription.contains("'" + connector.getName() + "'");
    }
}

