/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.common.retry.policies;

import org.mule.api.retry.RetryPolicy;
import org.mule.retry.PolicyStatus;

public class ForeverRetryPolicy
implements RetryPolicy {
    private final long sleepTime;

    public ForeverRetryPolicy(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public PolicyStatus applyPolicy(Throwable throwable) {
        if (throwable instanceof IllegalStateException && "Deque full".equals(throwable.getMessage())) {
            return PolicyStatus.policyExhausted((Throwable)throwable);
        }
        try {
            Thread.sleep(this.sleepTime);
            return PolicyStatus.policyOk();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return PolicyStatus.policyExhausted((Throwable)e);
        }
    }
}

