/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.common.retry.policies;

import org.mule.api.retry.RetryPolicy;
import org.mule.retry.PolicyStatus;

public class ExhaustingRetryPolicy
implements RetryPolicy {
    private final int retryLimit;
    private int retryCounter = 0;
    private final long sleepTime;

    public ExhaustingRetryPolicy(long sleepTime, int retryLimit) {
        this.sleepTime = sleepTime;
        this.retryLimit = retryLimit;
    }

    public PolicyStatus applyPolicy(Throwable throwable) {
        if (this.retryCounter >= this.retryLimit) {
            return PolicyStatus.policyExhausted((Throwable)throwable);
        }
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return PolicyStatus.policyExhausted((Throwable)e);
        }
        ++this.retryCounter;
        return PolicyStatus.policyOk();
    }
}

