(ns org.msync.spring-boost.application-context
  (:require [clojure.walk :refer [keywordize-keys]])
  (:import [org.springframework.core.env Environment]
           [java.util Map]
           [org.springframework.context ApplicationContext]
           [java.util.logging Logger]))

(defonce state (atom {}))
(defonce ^Logger log (Logger/getLogger (str *ns*)))

(gen-class
  :name
  ^{org.springframework.stereotype.Component "spring-boost-clojure-component"}
  org.msync.spring_boost.ClojureComponent
  :state _
  :prefix "-"
  :constructors {[org.springframework.context.ApplicationContext] []}
  :init component-init)

(defn- -component-init [^ApplicationContext ctx]
  (.info log "Initializing the ClojureComponent")
  (.info log (str "********************************** Application context: " ctx))
  (swap! state assoc :ctx ctx)
  [[] {}])

(defn- clojurize-map [^Map m]
  (keywordize-keys (into {} m)))

(defn ^ApplicationContext get-application-context []
  (println "Getting application context" @state)
  (:ctx @state))

(defn ^String id []
  (.getId (get-application-context)))

(defn ^String application-name []
  (.getApplicationName (get-application-context)))

(defn ^ApplicationContext parent []
  (.getParent (get-application-context)))

(defn ^Environment environment []
  (.getEnvironment (get-application-context)))

(defn ^Map beans
  ([] (beans Object))
  ([^Class clazz]
   (clojurize-map (.getBeansOfType (get-application-context) clazz))))

(defn ^Map beans-with-annotation [^Class annotation]
  (clojurize-map
    (.getBeansWithAnnotation (get-application-context) annotation)))
